/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpPreferenceUtil.java,v 1.8 2008/03/06 18:36:28 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.preferences;

import org.eclipse.hyades.test.tools.core.http.util.HttpConstants;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * HTTP preference utilities.
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version March 6, 2008
 * @since   February 1, 2005
 */
public class HttpPreferenceUtil
{
	private static HttpPreferenceUtil instance;

	private static String DEFAULTHOSTNAME = "DefaultHostName";
	private static String DEFAULTHOSTPORT = "DefaultHostPort";
	private static String DEFAULTABSOLUTEPATH = "DefaultAbsolutePath";
	private static String DEFAULTTHINKTIME = "DefaultThinkTime";
	private static String DEFAULTVARIANCE	= "DefaultVariance";

	private IPreferenceStore preferenceStore;

	private HttpPreferenceUtil()
	{
		preferenceStore = ToolsUiPlugin.getDefault().getPreferenceStore();
		setDefaultValues();
	}
	
	public static HttpPreferenceUtil getInstance()
	{
		if(instance == null)
			instance = new HttpPreferenceUtil();
			
		return instance;
	}
	

	private void setDefaultValues()
	{		
		preferenceStore.setDefault(DEFAULTHOSTNAME, "");
		preferenceStore.setDefault(DEFAULTHOSTPORT, "80");
		preferenceStore.setDefault(DEFAULTABSOLUTEPATH, "/");
		preferenceStore.setDefault( DEFAULTTHINKTIME, HttpConstants.DEFAULT_THINK_TIME );
		preferenceStore.setDefault( DEFAULTVARIANCE,  "10" );		
	}

	public String getDefaultHostName()
	{
		return getDefaultHostName(false);
	}

	public String getDefaultHostName(boolean defaultValue)
	{
		if(defaultValue)
			return preferenceStore.getDefaultString(DEFAULTHOSTNAME);
			
		return preferenceStore.getString(DEFAULTHOSTNAME);
	}

	public void setDefaultHostName(String value)
	{
		preferenceStore.setValue(DEFAULTHOSTNAME, value);
	}

	public String getDefaultHostPort()
	{
		return getDefaultHostPort(false);
	}

	public String getDefaultHostPort(boolean defaultValue)
	{
		if(defaultValue)
			return preferenceStore.getDefaultString(DEFAULTHOSTPORT);
			
		return preferenceStore.getString(DEFAULTHOSTPORT);
	}

	public void setDefaultHostPort(String value)
	{
		preferenceStore.setValue(DEFAULTHOSTPORT, value);
	}
	
	public String getDefaultAbsolutePath()
	{
		return getDefaultAbsolutePath(false);
	}

	public String getDefaultAbsolutePath(boolean defaultValue)
	{
		if(defaultValue)
			return preferenceStore.getDefaultString(DEFAULTABSOLUTEPATH);
			
		return preferenceStore.getString(DEFAULTABSOLUTEPATH);
	}

	public void setDefaultAbsolutePath(String value)
	{
		preferenceStore.setValue(DEFAULTABSOLUTEPATH, value);
	}
	
	public String getDefaultThinkTime()
	{
		return getDefaultThinkTime(false);
	}

	public String getDefaultThinkTime(boolean defaultValue)
	{
		if(defaultValue)
			return preferenceStore.getDefaultString(DEFAULTTHINKTIME);
			
		return preferenceStore.getString(DEFAULTTHINKTIME);
	}

	public void setDefaultThinkTime(String value)
	{
		preferenceStore.setValue(DEFAULTTHINKTIME, value);
	}

	public String getDefaultVariance()
	{
		return getDefaultVariance(false);
	}

	public String getDefaultVariance(boolean defaultValue)
	{
		if(defaultValue)
			return preferenceStore.getDefaultString(DEFAULTVARIANCE);
			
		return preferenceStore.getString(DEFAULTVARIANCE);
	}

	public void setDefaultVariance(String value)
	{
		preferenceStore.setValue(DEFAULTVARIANCE, value);
	}
}