/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TypeValidator.java,v 1.4 2005/02/25 22:17:54 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.http.junit;

import org.eclipse.hyades.test.tools.core.common.TestCommon;
import org.eclipse.hyades.ui.extension.ITypeValidator;

/**
 * Implementation of the ITypeValidator that accepts HTTP test suite types.
 * 
 */
public class TypeValidator
implements ITypeValidator
{
	/**
	 * @see org.eclipse.hyades.ui.extension.ITypeValidator#isValidType(java.lang.String)
	 */
	public boolean isValidType(String type)
	{
		if(TestCommon.HTTP_JUNIT_TEST_SUITE_TYPE.equals(type))
			return true;

		if(TestCommon.HTTP_JUNIT_TEST_CASE_TYPE.equals(type))
			return true;

		if(TestCommon.JUNIT_TEST_SUITE_TYPE.equals(type))
			return true;

		if(TestCommon.JUNIT_TEST_CASE_TYPE.equals(type))
			return true;
			
		return false;
	}
}
