/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpLaunchConfigurationDelegate.java,v 1.6 2008/04/18 20:12:53 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.http.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.harness.TestExecutionHarness;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.util.SaveManager;
import org.eclipse.hyades.test.core.TestCorePlugin;
import org.eclipse.hyades.test.core.TestCorePreferences;
import org.eclipse.hyades.test.core.launch.delegates.BasicTestLaunchConfigurationDelegate2;
import org.eclipse.hyades.test.tools.ui.http.internal.launch.HttpRunHandler;
import org.eclipse.hyades.test.tools.ui.http.internal.launch.HttpTestLaunchConfigurationFacade;

/**
 * Handles launching of a URL test via the Hyades Test Launch Configuration
 * @author jnevicos
 *
 * @provisional
 */
public class HttpLaunchConfigurationDelegate extends BasicTestLaunchConfigurationDelegate2 {
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.launch.delegates.AbstractLaunchConfigurationDelegate#getLaunchedElement(org.eclipse.debug.core.ILaunchConfiguration)
	 */
    protected TPFTest getLaunchedTest(ILaunchConfiguration configuration) throws CoreException {
    	return HttpTestLaunchConfigurationFacade.getTest(configuration, getResourceSet());
    }
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.launch.delegates.AbstractLaunchConfigurationDelegate#invokeTestExecutionHarness(org.eclipse.debug.core.ILaunchConfiguration, java.lang.String, java.lang.StringBuffer)
	 */
	public IExecutor invokeTestExecutionHarness(ILaunchConfiguration configuration, String mode,
			StringBuffer errorMessages, IProgressMonitor monitor) throws CoreException {
		// Compute parameters
    	TPFTest test = getLaunchedTest(configuration);
    	TPFTestSuite testSuite = null;
    	TPFTest subTest = null;
    	if (test instanceof TPFTestCase) {
    		subTest = test;
    		testSuite = ((TPFTestCase)subTest).getTestSuite();
    	} else if (test instanceof TPFTestSuite) {
    		testSuite = (TPFTestSuite)test;
    		subTest = test;
    	}
    	
    	HttpRunHandler.adjustTestUserCount(testSuite, configuration);
    	
    	TPFDeployment deployment = getDeployment(configuration);	    	
    	String tehName = getTestExecutionHistoryName(configuration);
    	String tehLocation = getTestExecutionHistoryLocation(configuration).getFullPath().toString();
    	String port = TestCorePlugin.getDefault().getPluginPreferences().getString(TestCorePreferences.DEFAULT_PORT);
    	
		TestExecutionHarness teh = new TestExecutionHarness();
		IExecutor executor = teh.launchTest(
			(ITestSuite)testSuite,
			(ITest)subTest,
			deployment,
			port,
			tehLocation,
			tehName,
			false, //overrideExisting - moving to non-deprecated method 3.2
			true,
			false,
			errorMessages,
			monitor);
		if (!monitor.isCanceled())
			SaveManager.getInstance().start(TestCorePlugin.getDefault().getPluginPreferences().getLong(TestCorePreferences.SAVE_INTERVAL));
		return executor;
	}
}