/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LoadTestUserTab.java,v 1.9 2007/04/26 18:50:21 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.http.launch.tabs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.http.TestHttpImages;
import org.eclipse.hyades.test.tools.ui.http.internal.launch.HttpTestLaunchConfigurationFacade;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

/**
 * Launch configuration tab that specifies number of virtual users to run with this test.
 * @author jnevicos
 * @author jcanches (bugzilla_64189)
 * @deprecated - users moved to test editor
 */
public class LoadTestUserTab extends AbstractLaunchConfigurationTab 
{

	private String title = ToolsUiPluginResourceBundle.LoadTestUserTab_Title;
	private Text _numUsers = null;
	
	private Listener modifyListener = new Listener() {
		public void handleEvent(Event e) {
			if (e.widget == _numUsers)
			{
				updateLaunchConfigurationDialog();
			}
		}
	};
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
        Composite composite = new Composite(parent, SWT.NULL);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.horizontalSpacing = 25;
        gl.verticalSpacing = 25;
        composite.setLayout(gl);
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
        composite.setFont(parent.getFont());
        Label users = new Label(composite, SWT.NONE);
		users.setText(ToolsUiPluginResourceBundle.LoadTestUserTab_Users);
		
		_numUsers = new Text(composite, SWT.BORDER);
		_numUsers.addListener(SWT.Modify, modifyListener);
		_numUsers.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		setControl(composite);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#setDefaults(org.eclipse.debug.core.ILaunchConfigurationWorkingCopy)
	 */
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
		HttpTestLaunchConfigurationFacade.setNumberOfUsers(configuration, 1);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#initializeFrom(org.eclipse.debug.core.ILaunchConfiguration)
	 */
	public void initializeFrom(ILaunchConfiguration configuration) {
		try {
    		int n = HttpTestLaunchConfigurationFacade.getNumberOfUsers(configuration);
    		String text;
    		if (n == -1) {
    			text = "";
    		} else {
    			text = Integer.toString(n);
    		}
    		if (_numUsers != null)
    		{
    			_numUsers.removeListener(SWT.Modify, modifyListener);  //don't want this event to be handled
    			_numUsers.setText(text);
    			_numUsers.addListener(SWT.Modify, modifyListener);
    		}
    	}
    	catch (CoreException e)
		{
    		ToolsUiPlugin.logError(e);
		}
	}
	/* (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#performApply(org.eclipse.debug.core.ILaunchConfigurationWorkingCopy)
	 */
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		HttpTestLaunchConfigurationFacade.setNumberOfUsers(configuration, get_nUsers());
	}
	/* (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#getName()
	 */
	public String getName() {
		return title;
	}
	/**
	 * @return Returns the _nUsers.
	 */
	public int get_nUsers() {
		try {
			int n = Integer.parseInt(_numUsers.getText());
			if (n > 0) {
				return n;
			} else {
				return -1;
			}
		} catch (NumberFormatException nfe) {
			return -1; // Denotes an incorrect integer
		}
	}
	/**
	 * @param users The _nUsers to set.
	 * @deprecated
	 */
	public void set_nUsers(int users) {
		// NOP
	}
	
	public Image getImage() {
		return TestHttpImages.INSTANCE.getImage(TestHttpImages.IMG_HTTP_TEST_CASE);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#isValid(org.eclipse.debug.core.ILaunchConfiguration)
	 */
	public boolean isValid(ILaunchConfiguration launchConfig) {
		setErrorMessage(null);
		if (get_nUsers() < 1) {
			setErrorMessage(ToolsUiPluginResourceBundle.LoadTestUserTab_InvalidUsers);
			return false;
		}
		return true;
	}
}
