/**********************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.java;

import org.eclipse.jdt.core.IMethod;

/*
* Implement this interface in your Test Suite proxy node if you need the "open source" contextual menu to be avalaible
* 
* @author  Jerome Bozier
* @version October 25, 2010
* @since   October 25, 2010
* @provisional As of TPTP V4.7.2 release, this is stable provisional API (see
http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html)
*/
public interface IJavaSourceTestCaseProxyNode {
	/**
	 * @provisional
	 * @return the java source method of test case, null if none is defined
	 */
	public IMethod getSourceMethod();
	
	/**
	 * @provisional
	 * @return the name of test case in a readable format
	 */
	public String getTestCaseName();
}
