/**********************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.java;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.tools.core.java.JUnitTestSuiteFacade;
import org.eclipse.hyades.test.ui.navigator.DefaultTestSuiteProxyNode;
import org.eclipse.ui.IMemento;

/*
* Abstract proxy node that extend DefaultTestSuiteProxyNode and add support for retrieving associated
* java source file
* 
* @author  Jerome Bozier
* @version October 25, 2010
* @since   October 25, 2010
* @provisional As of TPTP V4.7.2 release, this is stable provisional API (see
http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html)
*/
public abstract class JavaSourceTestSuiteProxyNode extends
		DefaultTestSuiteProxyNode implements IJavaSourceTestSuiteProxyNode {

	public JavaSourceTestSuiteProxyNode(IMemento memento, Object parent) {
		super(memento, parent);
	}

	public JavaSourceTestSuiteProxyNode(TPFTestSuite ts, Object parent) {
		super(ts, parent);
	}

	public IFile getSourceFile() {
		return JUnitTestSuiteFacade.getJUnitSourceFile(getTestSuite());
	}
	
	public String getSourceFileName() {
		TPFTestSuite ts = getTestSuite();
		if (ts != null) {
			return ts.getName();
		}
		return null; // should not happen
	}
	
	public void unload() {
		TPFTestSuite ts = getTestSuite();
		if (ts != null) {
			if (ts.eResource() != null) {
				ts.eResource().unload();
			}
		}
	}

}
