/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestJavaImages.java,v 1.7 2010/05/21 15:28:49 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java;

import java.net.URL;

import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.ui.internal.util.ImageManager;

/**
 * <p>Test Java image manager.</p>
 * 
 * <p><b>Note:</b>This class is not intended to be extended 
 * or used externally, and images are subject to be changed 
 * without notice.</p>
 * 
 * 
 * @author  Marcelo Patmarcelop
 * @author  Paul Slauenwhite
 * @version May 21, 2010
 * @since   February 2,2005
 */
public class TestJavaImages extends ImageManager {
	
	/**
	 * TestJavaImages' singleton.
	 */
	public static final TestJavaImages INSTANCE = new TestJavaImages();
	
	/**
	 * No-argument constructor.
	 */
	public TestJavaImages(){
		
		try	{
			initialize(new URL(ToolsUiPlugin.getDefault().getBundle().getEntry("/"), "icons/full/"), ToolsUiPlugin.getDefault().getImageRegistry()); //$NON-NLS-1$ //$NON-NLS-2$
		}
		catch(Exception e) {
			ToolsUiPlugin.logError(e);
		}	
	}
	
	/*
	 * Available cached Images in the Java plugin image registry.
	 */
	public static final String IMG_WIZBAN_IMPORT_JUNIT_TESTSUITE 		= "java_importjunit_wiz.gif"; //$NON-NLS-1$

	public static final String IMG_WIZBAN_NEW_JUNIT_TESTSUITE 		= "java_newjunit_wiz.gif"; //$NON-NLS-1$
	public static final String IMG_WIZBAN_NEW_JUNIT_TESTCASE 		= "java_newtest_wiz.gif"; //$NON-NLS-1$
	
	public static final String IMG_JUNIT_TEST_SUITE 				= "java_jsuite.gif"; //$NON-NLS-1$
	public static final String IMG_JUNIT_TEST_CASE 				    = "java_test.gif"; //$NON-NLS-1$
	
	/**
	 * @see org.eclipse.hyades.ui.util.ImageManager#addImages()
	 */
	protected void addImages()
	{
		
		add(T_WIZBAN, IMG_WIZBAN_IMPORT_JUNIT_TESTSUITE);
		
		add(T_WIZBAN, IMG_WIZBAN_NEW_JUNIT_TESTSUITE);
		add(T_WIZBAN, IMG_WIZBAN_NEW_JUNIT_TESTCASE);

		add(T_OBJ, IMG_JUNIT_TEST_SUITE);
		add(T_OBJ, IMG_JUNIT_TEST_CASE);
	}	
}
