/*******************************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenTestMethodAction.java,v 1.5 2009/05/08 11:23:12 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.actions;

import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.tools.core.internal.util.JavaUtil;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

/**
 * <p>Action to open the generated source code at a specific method.</p>
 *   
 * 
 * @author  Paul E. Slauenwhite
 * @version May 4, 2009
 * @since   May 4, 2009
 */
public class OpenTestMethodAction extends BaseSelectionListenerAction {

	private ITestCase testCase = null;

	public OpenTestMethodAction() {
		
		super(UiPluginResourceBundle.ACT_OPEN);
		
		setToolTipText(UiPluginResourceBundle.ACT_TEST_METHOD_OPEN_TIP); 
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	public void run() {

		IMethod method = JavaUtil.findMethod(testCase);

		if (method != null) {

			try {

				IEditorPart part = JavaUI.openInEditor(method);

				JavaUI.revealInEditor(part, ((IJavaElement)(method)));
			} 
			catch (Exception e) {
				ToolsUiPlugin.logError(e);
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.actions.BaseSelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection selection) {

		if (selection.size() == 1) {

			Object firstElement = selection.getFirstElement();

			if (firstElement instanceof ITestCase) {

				testCase = ((ITestCase)(firstElement));

				if(JavaUtil.findMethod(testCase) != null){
					return true;
				}
			}
		}

		testCase = null;

		return false;
	}
}
