/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CodeUpdatePreviewOptionsGroup.java,v 1.1 2009/05/19 02:26:25 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.controls;

import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.preferences.JUnitUIPreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/**
 * <p>CodeUpdatePreviewOptionsGroup.java</p>
 * 
 * 
 * @author  Paul Slauenwhite
 * @version May 18, 2009
 * @since   May 18, 2009
 */
public class CodeUpdatePreviewOptionsGroup extends Composite {

	private Button alwaysPreviewButton = null;
	private Button destructiveChangesPreviewButton = null;
	private Button neverPreviewButton = null;
	private Button promptPreviewButton = null;
	
	public CodeUpdatePreviewOptionsGroup(Composite parent, int style) {
		
		super(parent, style);

		createControl();
	}
	
	public void initialize(IPreferenceStore prefs) {
		
		resetPreview();
		
		switch (prefs.getInt(JUnitUIPreferences.CODE_UPDATE_PREVIEW_MODE)) {
		case JUnitUIPreferences.ALWAYS_PREVIEW:
			alwaysPreviewButton.setSelection(true);
			break;
		case JUnitUIPreferences.DESTRUCTIVE_CHAGES_PREVIEW:
			destructiveChangesPreviewButton.setSelection(true);
			break;
		case JUnitUIPreferences.NEVER_PREVIEW:
			neverPreviewButton.setSelection(true);
			break;
		case JUnitUIPreferences.PROMPT_PREVIEW:
			promptPreviewButton.setSelection(true);
			break;
		}
	}
	
	public void resetToDefaults(IPreferenceStore prefs) {
		
		resetPreview();
		
		switch (prefs.getDefaultInt(JUnitUIPreferences.CODE_UPDATE_PREVIEW_MODE)) {
		case JUnitUIPreferences.ALWAYS_PREVIEW:
			alwaysPreviewButton.setSelection(true);
			break;
		case JUnitUIPreferences.DESTRUCTIVE_CHAGES_PREVIEW:
			destructiveChangesPreviewButton.setSelection(true);
			break;
		case JUnitUIPreferences.NEVER_PREVIEW:
			neverPreviewButton.setSelection(true);
			break;
		case JUnitUIPreferences.PROMPT_PREVIEW:
			promptPreviewButton.setSelection(true);
			break;
		}
	}

	public void save(IPreferenceStore prefs) {
		
		int value = -1;
		
		if (alwaysPreviewButton.getSelection()) {
			value = JUnitUIPreferences.ALWAYS_PREVIEW;
		} 
		else if (destructiveChangesPreviewButton.getSelection()) {
			value = JUnitUIPreferences.DESTRUCTIVE_CHAGES_PREVIEW;
		} 
		else if (neverPreviewButton.getSelection()) {
			value = JUnitUIPreferences.NEVER_PREVIEW;
		}
		else if (promptPreviewButton.getSelection()) {
			value = JUnitUIPreferences.PROMPT_PREVIEW;
		}
	
		prefs.setValue(JUnitUIPreferences.CODE_UPDATE_PREVIEW_MODE, value);
	}

	private void createControl() {
		
		GridLayout compositeGridLayout = new GridLayout(1, true);		
		compositeGridLayout.marginWidth = compositeGridLayout.marginHeight = 0;
		compositeGridLayout.horizontalSpacing = compositeGridLayout.verticalSpacing = 0;

		setLayout(compositeGridLayout);
		setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		Group previewCodeGroup = new Group(this, SWT.None);
		previewCodeGroup.setText(ToolsUiPluginResourceBundle.CODE_UPDATE_PREVIEW_GROUP); 
		previewCodeGroup.setLayout(new GridLayout(1, true));
		previewCodeGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
				
		alwaysPreviewButton = new Button(previewCodeGroup, SWT.RADIO);
		alwaysPreviewButton.setText(ToolsUiPluginResourceBundle.ALWAYS_CODE_UPDATE_PREVIEW_LABEL); 

		destructiveChangesPreviewButton = new Button(previewCodeGroup, SWT.RADIO);
		destructiveChangesPreviewButton.setText(ToolsUiPluginResourceBundle.DESTRUCTIVE_CHANGES_CODE_UPDATE_PREVIEW_LABEL); 

		neverPreviewButton = new Button(previewCodeGroup, SWT.RADIO);
		neverPreviewButton.setText(ToolsUiPluginResourceBundle.NEVER_CODE_UPDATE_PREVIEW_LABEL); 

		promptPreviewButton = new Button(previewCodeGroup, SWT.RADIO);
		promptPreviewButton.setText(ToolsUiPluginResourceBundle.PROMPT_CODE_UPDATE_PREVIEW_LABEL); 		
	}
	
	private void resetPreview() {
		
		alwaysPreviewButton.setSelection(false);
		destructiveChangesPreviewButton.setSelection(false);
		neverPreviewButton.setSelection(false);
		promptPreviewButton.setSelection(false);
	}
}
