/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitTestSuiteImportOptionsControl.java,v 1.6 2008/01/22 13:24:56 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.controls;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor;
import org.eclipse.hyades.test.tools.core.internal.java.preferences.JUnitPreferences;
import org.eclipse.hyades.test.tools.ui.java.internal.JavaMessages;
import org.eclipse.hyades.test.ui.internal.util.SpecialFieldsBidiListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

/**
 * JUnit test suite import options.
 * 
 * 
 * @author  Julien Canches
 * @author  Paul E. Slauenwhite
 * @version January 22, 2008
 * @since   Sepember 1, 2006
 */
public class JUnitTestSuiteImportOptionsControl extends Composite {

	private ComboViewer defaultTestSuiteTypeCombo;
	private StyledText defaultTestSuitePathText;
	private JUnitTestSuiteFactoriesProvider factoriesProvider;
	
	private SelectionListener patternMenuListener = new SelectionAdapter() {
		public void widgetSelected(SelectionEvent e) {
			defaultTestSuitePathText.setText((String)e.widget.getData());
		}
	};
	
	public JUnitTestSuiteImportOptionsControl(Composite parent, int style) {
		super(parent, style);
		GridLayout layout = new GridLayout(2, false);
		setLayout(layout);
		
		Label label = new Label(this, SWT.NONE);
		label.setText(JavaMessages.JUNIT_IMPORT_DEFAULT_TYPE);
		label.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));
		
		defaultTestSuiteTypeCombo = new ComboViewer(this);
		defaultTestSuiteTypeCombo.getControl().setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false));
		
		label = new Label(this, SWT.NONE);
		label.setText(JavaMessages.JUNIT_IMPORT_DEFAULT_PATH);
		label.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));
		
		defaultTestSuitePathText = new StyledText(this, (SWT.FULL_SELECTION | SWT.SINGLE | SWT.LEFT_TO_RIGHT | SWT.BORDER));
		defaultTestSuitePathText.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false));
		defaultTestSuitePathText.addBidiSegmentListener(SpecialFieldsBidiListener.createPathFieldBidiListener());
		
		label = new Label(this, SWT.NONE);
		label.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));
		
		Control pathTools = createPathTools(this);
		pathTools.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false));
	}
	
	protected Control createPathTools(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout(2, false);
		composite.setLayout(layout);
		
		Link link = new Link(composite, SWT.NONE);
		link.setText("<a>" + JavaMessages.JUNIT_IMPORT_PATTERNS + "</a>"); //$NON-NLS-1$ //$NON-NLS-2$
		link.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, true, false));
		
		final Menu menu = new Menu(link);
		createPatternMenuItem(menu, JavaMessages.JUNIT_IMPORT_PATTERN_SAME_FOLDER, JUnitPreferences.DEFAULT_DEFAULT_JUNIT_TEST_SUITE_PATH);
		createPatternMenuItem(menu, JavaMessages.JUNIT_IMPORT_PATTERN_COMMON_JUNIT_FOLDER, JUnitPreferences.DEFAULT_DEFAULT_COMMON_JUNIT_TEST_SUITE_PATH);
		
		link.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				menu.setVisible(true);
			}
		});
		
		Control buttons = createButtons(composite);
		buttons.setLayoutData(new GridData(SWT.END, SWT.BEGINNING, true, false));
		
		return composite;
	}
	
	protected Control createButtons(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		RowLayout layout = new RowLayout();
		layout.pack = false;
		composite.setLayout(layout);
		
		Button button = new Button(composite, SWT.PUSH);
		button.setText(JavaMessages.JUNIT_IMPORT_CHOOSE_IN_WORKSPACE);
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleBrowseWorkspace();
			}
		});
		
		button = new Button(composite, SWT.PUSH);
		button.setText(JavaMessages.JUNIT_IMPORT_CHOOSE_VARIABLE);
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleBrowseVariables();
			}
		});
		
		return composite;
	}
	
	protected MenuItem createPatternMenuItem(Menu menu, String text, String pattern) {
		MenuItem item = new MenuItem(menu, SWT.PUSH);
		item.setText(text);
		item.setData(pattern);
		item.addSelectionListener(patternMenuListener);
		return item;
	}
	
	protected void handleBrowseWorkspace() {
		ContainerSelectionDialog dialog = 
			new ContainerSelectionDialog(getShell(), getContainer(), true, JavaMessages.JUNIT_IMPORT_CHOOSE_FOLDER_PROMPT); 
		if (dialog.open() == Window.OK) {
			Object[] result = dialog.getResult();
			if (result.length == 0)	return;
			IPath path = (IPath)result[0];
			defaultTestSuitePathText.setText(path.toPortableString());
		}
	}

	protected void handleBrowseVariables() {
		StringVariableSelectionDialog dialog = 
			new StringVariableSelectionDialog(getShell());
		dialog.setFilter("tptp_junit"); //$NON-NLS-1$
		if (dialog.open() == Window.OK)
			defaultTestSuitePathText.insert(dialog.getVariableExpression());
	}

	protected IContainer getContainer() {
		String path = defaultTestSuitePathText.getText();
		if (path.length() > 0) {
		    IResource res = null;
		    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
	        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
		    try {
                path = manager.performStringSubstitution(path, false);
                res = root.findMember(new Path(path));
                if (res != null && res.getType() == IResource.FILE) {
                    res = res.getParent();
                }
            } catch (CoreException e) {
            }
			if (res instanceof IContainer) {
				return (IContainer)res;
			}
		}
		return ResourcesPlugin.getWorkspace().getRoot();
	}
	
	/**
	 * Initializes the control content.
	 * @param prefs The preference store to read and store preferences.
	 * @param project An optional project. If not <code>null</code, only the type factories that support
	 * this project will be presented to the user.
	 */
	public void initialize(IPreferenceStore prefs, IProject project) {
		IJavaElement jelem;
		if (project != null) {
			jelem = JavaCore.create(project);
		} else {
			jelem = JavaCore.create(ResourcesPlugin.getWorkspace().getRoot());
		}
		factoriesProvider = new JUnitTestSuiteFactoriesProvider();
		defaultTestSuiteTypeCombo.setLabelProvider(factoriesProvider);
		defaultTestSuiteTypeCombo.setContentProvider(factoriesProvider);
		defaultTestSuiteTypeCombo.setInput(jelem);

		String defType = prefs.getString(JUnitPreferences.DEFAULT_JUNIT_TEST_SUITE_FACTORY);
		JUnitTestSuiteFactoryDescriptor descriptor = factoriesProvider.getElement(defType);
		if (descriptor != null) {
			defaultTestSuiteTypeCombo.setSelection(new StructuredSelection(descriptor));
		}
		
		String defPath = prefs.getString(JUnitPreferences.DEFAULT_JUNIT_TEST_SUITE_PATH);
		defaultTestSuitePathText.setText(defPath);
	}
	
	public void save(IPreferenceStore prefs) {
		String defType = null;
		ISelection selection = defaultTestSuiteTypeCombo.getSelection();
		if (selection instanceof IStructuredSelection) {
			Object sel = ((IStructuredSelection)selection).getFirstElement();
			if (sel != null && sel instanceof JUnitTestSuiteFactoryDescriptor) {
				defType = ((JUnitTestSuiteFactoryDescriptor)sel).getType();
			}
		}
		if (defType != null) {
			prefs.setValue(JUnitPreferences.DEFAULT_JUNIT_TEST_SUITE_FACTORY, defType);
		}
		
		prefs.setValue(JUnitPreferences.DEFAULT_JUNIT_TEST_SUITE_PATH, defaultTestSuitePathText.getText());
	}
	
	public void resetToDefaults(IPreferenceStore prefs) {
		String defType = prefs.getDefaultString(JUnitPreferences.DEFAULT_JUNIT_TEST_SUITE_FACTORY);
		JUnitTestSuiteFactoryDescriptor descriptor = factoriesProvider.getElement(defType);
		if (descriptor != null) {
			defaultTestSuiteTypeCombo.setSelection(new StructuredSelection(descriptor));
		}
		
		String defPath = prefs.getDefaultString(JUnitPreferences.DEFAULT_JUNIT_TEST_SUITE_PATH);
		defaultTestSuitePathText.setText(defPath);
	}
	
}
