/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitBehaviorForm.java,v 1.9 2008/04/16 18:11:02 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.editor;

import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.BehaviorForm;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.BehaviorSection;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.LoopDetailPage;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.TestInvocationDetailPage;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.TestSuiteEditorExtension;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.util.ContextIds;
import org.eclipse.hyades.test.tools.ui.java.internal.util.TestJavaUtil;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.StaticDetailPageProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.widgets.Control;

/**
 * JUnitBehaviorForm.java
 * <p/>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Marcelo Paternostro
 * @version April 16, 2008
 * @since   February 1, 2005
 */
public class JUnitBehaviorForm
extends BehaviorForm
{
	/**
	 * Constructor for JUnitBehaviorForm
	 * @param junitEditorExtension
	 * @param widgetFactory
	 */
	public JUnitBehaviorForm(JUnitEditorExtension junitEditorExtension, WidgetFactory widgetFactory)
	{
		super(junitEditorExtension, widgetFactory);
		setHeadingText(ToolsUiPluginResourceBundle.EDT_JUNIT_TTL); 
	}
	
	protected JUnitBehaviorForm(TestSuiteEditorExtension testSuiteEditorExtension, WidgetFactory widgetFactory)
	{
		super(testSuiteEditorExtension, widgetFactory);
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.BehaviorForm#createBehaviorSection()
	 */
	protected BehaviorSection createBehaviorSection()
	{
		return new JUnitBehaviorSection(this);
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestCasesForm#registerHelp(int, java.lang.Object)
	 */
	protected void registerHelp(int flag, Object object)
	{
		switch(flag)
		{
			case HELP_NAMED_ELEMENT_CONTROL:
				ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)object, ToolsUiPlugin.getID() + ContextIds.BEHAVIOR_NAME_FORM);
				break;
				
			case HELP_FORM_CONTROL:
				ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)object, ToolsUiPlugin.getID() + ContextIds.BEHAVIOR_FORM);
				break;
				
			case HELP_SECTION_CONTROL:
				ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)object, ToolsUiPlugin.getID() + ContextIds.BEHAVIOR_SECTION_FORM);
				break;
		}
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.BehaviorForm#addDetails(org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection)
	 */
	protected void addDetails(StaticDetailPageProvider detailPageProvider)
	{
		detailPageProvider.addDetailPage(ILoop.class, new LoopDetailPage()
		{
			protected String getIteractionsLabel()
			{
				return ToolsUiPluginResourceBundle.LBL_NBR_ITERS; 
			}
			
			protected String getSynchronousLabel()
			{
				return ToolsUiPluginResourceBundle.BTN_IS_SYNC; 
			}

			protected void registerHelp(int flag, Object object)
			{
				switch(flag)
				{
					case HELP_PAGE_CONTROL:
						ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)object, ToolsUiPlugin.getID() + ContextIds.LOOP_DETAIL_PAGE);				
						break;

					case HELP_ITERATION_CONTROL:
						ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)object, ToolsUiPlugin.getID() + ContextIds.LOOP_DETAIL_TEXT);				
						break;

					case HELP_SYNCHRONOUS_CONTROL:
						ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)object, ToolsUiPlugin.getID() + ContextIds.LOOP_DETAIL_SYNCH);				
						break;
				}
			}
		});
		
		detailPageProvider.addDetailPage(ITestInvocation.class, new TestInvocationDetailPage()
		{
			protected InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite testSuite)
			{
				return TestJavaUtil.createInvokedTestSelectionDialog(testSuite, true);
			}

			protected String getSynchronousLabel()
			{
				return ToolsUiPluginResourceBundle.BTN_IS_SYNC; 
			}

			protected String getDefaultLinkText()
			{
				return UiPluginResourceBundle.NO_TST_TO_INV; 
			}
			
			protected String getDefaultLinkToolTip()
			{
				return UiPluginResourceBundle.TIP_INV_TEST; 
			}
		});
	}	
}
