/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitForm.java,v 1.10 2008/01/21 16:59:13 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.editor;

import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.TestSuiteEditorExtension;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.TestSuiteForm;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class JUnitForm 
extends TestSuiteForm
{
	private SourceInfoSection sourceInfoSection;
	
	/**
	 * Constructor for JUnitForm
	 * @param junitEditorExtension
	 * @param widgetFactory
	 */
	public JUnitForm(JUnitEditorExtension junitEditorExtension, WidgetFactory widgetFactory)
	{
		super(junitEditorExtension, widgetFactory);
		setHeadingText(ToolsUiPluginResourceBundle.EDT_JUNIT_TTL); 
	}

	protected JUnitForm(TestSuiteEditorExtension testSuiteEditorExtension, WidgetFactory widgetFactory)
	{
		super(testSuiteEditorExtension, widgetFactory);
	}


	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		sourceInfoSection.dispose();
	}
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestSuiteForm#registerHelp(int, java.lang.Object)
	 */
	protected void registerHelp(int flag, Object object)
	{
		switch(flag)
		{
			case HELP_FORM_CONTROL:
				ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)object, ToolsUiPlugin.getID() + ContextIds.JUNIT_FORM);
				break;
				
			case HELP_TEST_CASE_CONTROL:
				ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)object, ToolsUiPlugin.getID() + ContextIds.JUNIT_FORM_METHOD);
				break;
				
			case HELP_TYPE_CONTROL:
				ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)object, ToolsUiPlugin.getID() + ContextIds.JUNIT_FORM_TYPE);
				break;

			case HELP_FILE_CASE_CONTROL:
				ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)object, ToolsUiPlugin.getID() + ContextIds.JUNIT_FORM_NAME);
				break;
		}
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestSuiteForm#createTestCaseElementsSectionControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementsSection)
	 */
	protected Control createTestCaseElementsSectionControl(Composite parent, NamedElementsSection testCaseElementsSection)
	{
		return testCaseElementsSection.createControl(parent, factory, ToolsUiPluginResourceBundle.EDT_JUNIT_TST_METHS, ToolsUiPluginResourceBundle.EDT_JUNIT_TST_METHS_DSC); 
	}

	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestSuiteForm#createLeftColumnControls(org.eclipse.swt.widgets.Composite)
	 */
	protected void createLeftColumnControls(Composite parent)
	{
		//super.createLeftColumnControls(parent);
		Control control = createGenericInformation(parent, ToolsUiPluginResourceBundle.EDT_JUNIT_TTL, ToolsUiPluginResourceBundle.EDT_JUNIT_DSC); 
		control.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING));
		registerHelp(HELP_FORM_CONTROL, control);
		
		createSourceInfoSection(parent);
	}
	
	protected void createSourceInfoSection(Composite parent)
	{
		sourceInfoSection = new SourceInfoSection(this);
		sourceInfoSection.setHeaderText(ToolsUiPluginResourceBundle.SRC_TTL); 
		Control control = sourceInfoSection.createControl(parent, getWidgetFactory());
		control.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING));
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestSuiteForm#load()
	 */
	public void load()
	{
		super.load();
		sourceInfoSection.setInput(getTestSuite());
	}
	
	public void reloadSourceInfo() {
		sourceInfoSection.setInput(getTestSuite());
	}
}
