/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitTestCasesForm.java,v 1.14 2009/05/04 14:37:13 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.editor;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.tools.core.common.TestCommon;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.TestCasesForm;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.AddTestCase;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.actions.OpenTestMethodAction;
import org.eclipse.hyades.test.tools.ui.java.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTreeSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.TreeSection;
import org.eclipse.hyades.test.ui.internal.model.ui.ChildrenSelectionAction;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenDownAction;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenUpAction;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveChildrenAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Control;

/**
 * <p>JUnitTestCasesForm.java</p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul Slauenwhite
 * @version May 4, 2009
 * @since   Februrary 1, 2005
 */
public class JUnitTestCasesForm extends TestCasesForm {
    /**
     * Constructor for JUnitTestCasesForm
     * 
     * @param junitEditorExtension
     * @param widgetFactory
     */
    public JUnitTestCasesForm(JUnitEditorExtension junitEditorExtension, WidgetFactory widgetFactory) {
        super(junitEditorExtension, widgetFactory);
        setHeadingText(ToolsUiPluginResourceBundle.EDT_JUNIT_TTL); 
    }

    /**
     * @see org.eclipse.hyades.test.java.internal.junit.editor.TestCasesForm#getAddTestCaseAction()
     */
    protected IAction getAddTestCaseAction() {
        return new AddTestCase(this, TestCommon.JUNIT_TEST_CASE_TYPE, ToolsUiPluginResourceBundle.DEFAULT_TESTCASE_NAME_VALUE.toLowerCase()); 
    }

    /**
     * @see org.eclipse.hyades.test.java.internal.junit.editor.TestCasesForm#getTestCasesSectionHeaderText()
     */
    protected String getTestCasesSectionHeaderText() {
        return ToolsUiPluginResourceBundle.W_TST_METHS; 
    }
    
    protected TreeSection createTestCasesSection() {
    	IAction[] actions = new IAction[] {
    		getAddTestCaseAction(),
    		new RemoveChildrenAction(false),
            new MoveChildrenUpAction(),
            new MoveChildrenDownAction(),
            new OpenTestMethodAction(),
    	};
    	EStructuralFeature feature = Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases();
    	((MoveChildrenUpAction)actions[2]).setEStructuralFeature(feature);
    	((MoveChildrenDownAction)actions[3]).setEStructuralFeature(feature);
    	ExtensibleEObjectTreeSection section = new ExtensibleEObjectTreeSection(this, feature, actions);
    	section.setEditable(true);
    	for (int i = 0; i < actions.length; i++) {
    		if (actions[i] instanceof ChildrenSelectionAction) {
    			((ChildrenSelectionAction)actions[i]).setStructuredViewer(section.getTreeViewer());
    		}
    	}
    	return section;
	}
    
	/**
     * @see org.eclipse.hyades.test.common.internal.editor.TestCasesForm#registerHelp(int,
     *      java.lang.Object)
     */
    protected void registerHelp(int flag, Object object) {
        switch (flag) {
            case HELP_NAMED_ELEMENT_CONTROL:
                ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control) object, ToolsUiPlugin.getID() + ContextIds.TEST_METH_SECTION_NAME);
                break;

            case HELP_TEST_CASES_SECTION_CONTROL:
                ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control) object, ToolsUiPlugin.getID() + ContextIds.TEST_METH_SECTION);
                break;

            case HELP_TEST_CASES_SECTION_TREE_CONTROL:
                ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control) object, ToolsUiPlugin.getID() + ContextIds.TEST_METH_SECTION_TREE);
                break;
        }
    }
    
}
