/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IJavaElementChangedListenerProxyNode.java,v 1.3 2007/05/02 19:36:08 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jdt.core.IJavaElementDelta;

/**
 * A proxy node that is able to modify itself in reaction to changes in the java model.
 * @author jcanches
 * @since 4.3
 */
public interface IJavaElementChangedListenerProxyNode extends IProxyNode {

	/**
	 * Processes the delta, rooted at the java element that this proxy is associated to.
	 * @param delta
	 * @return The lowest proxy, in the subtree of the proxy, that needs to be refreshed
	 * by a viewer. This may be this proxy itself.
	 */
	IProxyNode elementChanged(IJavaElementDelta delta);
	
}
