
/********************************************************************** 
 * Copyright (c) 2005, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: JUnitFolderProxyNode.java,v 1.9 2007/06/01 14:51:54 jgout Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IResourceChangeListenerProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestFolderContentValidator;
import org.eclipse.hyades.test.ui.navigator.TestFolderProxyNode;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/**
 * Proxy node to handle folders found in Java project.
 * Those folders can be either basic folder or source folder (that are part of the project classpath).
 *  
 * @author jgout
 * @since 4.0
 */
public class JUnitFolderProxyNode extends TestFolderProxyNode {

	/** the type of test that this provider proxy node covers */
    private String type;
    
    private Object claimedParent;
    
    public static JUnitFolderProxyNode create(IContainer container, ITestFolderContentValidator validator, String type, IFileProxyManager fileProxyManager, Object parent) {
        JUnitFolderProxyNode proxy = new JUnitFolderProxyNode(container, validator, type, fileProxyManager, parent);
        if(proxy.getChildren().length > 0) {
            return proxy;
        }
        return null;
    }

    /**
     * @see org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer#isApplicableFor()
     */
    public boolean isApplicableFor() {
        //- this proxy node is node renamable
        return false;
    }
    
    protected JUnitFolderProxyNode(IContainer container, ITestFolderContentValidator validator, String type, IFileProxyManager fileProxyManager, Object parent) {
    	super(container, validator, fileProxyManager, false, parent, false);
    	this.claimedParent = this;
    	computeChildren();
    }
    
    protected JUnitFolderProxyNode(IContainer container, ITestFolderContentValidator validator, String type, IFileProxyManager fileProxyManager, Object parent, Object claimedParent) {
    	super(container, validator, fileProxyManager, false, parent, false);
    	this.claimedParent = claimedParent;
    	computeChildren();
    }
    
	/**
     * @see org.eclipse.hyades.test.ui.internal.navigator.proxy.TestFolderProxyNode#createChildFolderProxyNode(org.eclipse.core.resources.IContainer)
     */
    protected IResourceChangeListenerProxyNode createChildFolderProxyNode(IContainer container) {
        IJavaProject jProject = JavaCore.create(container.getProject());
        IPackageFragmentRoot root;
        try {
            root = jProject.findPackageFragmentRoot(container.getFullPath());
        } catch (JavaModelException e) {
            root = null;
        }
        if(root != null){
            return SourceFolderProxyNode.create(root, getValidator(), getFileProxyManager(), getChildrenParent());
        } else {
            //- this is not a java source folder, recursive call
            return create(container, getValidator(), type, getFileProxyManager(), getChildrenParent());
        }
    }
    
    /** 
     * @see org.eclipse.hyades.test.ui.navigator.TestFolderProxyNode#createChildFileProxyNode(org.eclipse.core.resources.IFile)
     */
    protected IProxyNode createChildFileProxyNode(IFile file) {
        return getFileProxyManager().getProxy(file, getChildrenParent());
    }
    
    /**
     * @return the parent of the children created by this proxy node.
     * @since 4.4
     */
    protected Object getChildrenParent() {
        return claimedParent;
    }
    
    public IResource getCorrespondingResource() {
		return getUnderlyingResource();
	}

}
