/********************************************************************** 
 * Copyright (c) 2008, 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: JUnitTestCaseProxyNode.java,v 1.2 2010/10/25 12:31:06 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.test.tools.ui.java.JavaSourceTestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.ui.IMemento;

/**
 * JUnit test case proxy node to specialize the actions in the context menu 
 * of the Test Navigator.
 * <p/>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Jerome Bozier
 * @version	October 25, 2010
 * @since 	July 23, 2008
 */
public class JUnitTestCaseProxyNode extends JavaSourceTestCaseProxyNode implements ITestCaseProxyNode {

    public JUnitTestCaseProxyNode(TPFTestCase ts, Object parent) {
        super(ts, parent);
    }
    
    public JUnitTestCaseProxyNode(IMemento memento, Object parent) {
        super(memento, parent);
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTestCaseProxyNode#getFactoryID()
     */
    public String getFactoryID() {
        return "org.eclipse.hyades.test.tools.ui.JUnitTestSuiteFactory"; //$NON-NLS-1$
    }
}
