/********************************************************************** 
 * Copyright (c) 2005, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: JUnitTestSuiteProxyFactory.java,v 1.2 2008/07/23 13:27:55 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.navigator.DefaultTypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.ui.IMemento;

/**
 * This factory is responsible to create special proxy nodes for JUnit test cases and suites.
 * <p/>
 * Those test cases should have the type org.eclipse.hyades.test.java.junit.testCase.
 * <p/>
 * Those test suites should have the type org.eclipse.hyades.test.java.junit.testSuite.
 * <p/>
 *
 * 
 * @author  Jerome Gout
 * @author  Paul E. Slauenwhite
 * @version July 23, 2008
 * @since   March 25, 2005
 */
public class JUnitTestSuiteProxyFactory extends DefaultTypedElementProxyFactory {

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory#create(org.eclipse.hyades.models.common.testprofile.TPFTest, java.lang.Object)
     */
    public IProxyNode create(TPFTest test, Object parent) {
        if (test instanceof TPFTestSuite) {
            TPFTestSuite ts = (TPFTestSuite) test;
            return new JUnitTestSuiteProxyNode(ts, parent);
        }
        else if (test instanceof TPFTestCase) {
        	TPFTestCase tc = (TPFTestCase) test;
            return new JUnitTestCaseProxyNode(tc, parent);
        }

        return super.create(test, parent);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.navigator.IPersistableTypedElementProxyFactory#recreate(org.eclipse.ui.IMemento, java.lang.Object)
     */
    public IProxyNode recreate(IMemento memento, Object parent) {
        String nodeKind = memento.getString(TestUIConstants.TAG_NODE_KIND);
        if(nodeKind.equals(TestUIConstants.TESTSUITE_NODE)) {
            return new JUnitTestSuiteProxyNode(memento, parent);
        } 
        else if(nodeKind.equals(TestUIConstants.TESTCASE_NODE)) {
            return (new JUnitTestCaseProxyNode(memento, parent));
        } 
        else {
            //- since this is not a saved test case or suite, let's default factory handle this memento 
            return super.recreate(memento, parent);
        }
    }
}
