/********************************************************************** 
 * Copyright (c) 2005, 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: JUnitTestSuiteProxyNode.java,v 1.6 2010/10/25 12:31:06 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.tools.ui.java.JavaSourceTestSuiteProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.ui.IMemento;

/**
 * Simple wrapper around DefaultTestSuiteProxyNode.
 * This class is done to specialize the actions in the context menu of the test navigator views.
 * @author Jerome Gout
 * @author Jerome Bozier
 * @version October 25, 2010
 * @since 4.0
 */
public class JUnitTestSuiteProxyNode extends JavaSourceTestSuiteProxyNode implements ITestSuiteProxyNode {

    public JUnitTestSuiteProxyNode(TPFTestSuite ts, Object parent) {
        super(ts, parent);
    }
    
    public JUnitTestSuiteProxyNode(IMemento memento, Object parent) {
        super(memento, parent);
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode#getFactoryID()
     */
    public String getFactoryID() {
        return "org.eclipse.hyades.test.tools.ui.JUnitTestSuiteFactory"; //$NON-NLS-1$
    }
    
}
