/********************************************************************** 
 * Copyright (c) 2005, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: JUnitTypeProvider.java,v 1.10 2007/03/01 19:29:34 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNodeListener;
import org.eclipse.hyades.test.ui.navigator.IResourceChangeListenerProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypeProvider;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderContext;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderProxyNode;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jdt.core.JavaCore;

/** 
 * Type provider for JUnit Test type.
 * @author jgout
 * @since 4.0
 */
public class JUnitTypeProvider implements ITypeProvider, IResourceChangeListener, IDisposable {
    
    /** The file proxy manager used to cache file proxies */
    protected IFileProxyManager fileProxyManager;
	protected IProxyNodeListener refresher;

	private Map projectToProxyMap = Collections.synchronizedMap(new HashMap());
	
	public JUnitTypeProvider() {
        FileProxyNodeCache.getInstance().addResourceListener(this);
	}
	
    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.navigator.ITypeProvider#get(org.eclipse.core.resources.IProject, java.lang.String)
     */
    public ITypeProviderProxyNode get(IProject project, String type) {
        if(!JavaCore.create(project).exists()) {
            return null;
        }
        if(projectToProxyMap.containsKey(project)) {
            return (ITypeProviderProxyNode) projectToProxyMap.get(project);
        } else {
        	ITypeProviderProxyNode node = createTypeProviderProxyNode(project, type);
            if (node != null) {
                projectToProxyMap.put(project, node);
            }
            return node;
        }
//		JUnitTypeProviderProxyNode node = (JUnitTypeProviderProxyNode) projectToProxyMap.get(project);
//		if (node == null) {
//			node = JUnitTypeProviderProxyNode.create(project, type, fileProxyManager, project);
//			projectToProxyMap.put(project, node);
//		}
//        return node;
    }
    
    protected ITypeProviderProxyNode createTypeProviderProxyNode(IProject project, String type) {
    	return JUnitTypeProviderProxyNode.create(project, type, fileProxyManager, project);
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.navigator.ITypeProvider#init(org.eclipse.hyades.test.ui.navigator.ITypeProviderContext)
     */
    public void init(ITypeProviderContext context) {
        fileProxyManager = context.getFileProxyManager();
		refresher = context.getProxyNodeListener();
    }

	public void resourceChanged(IResourceChangeEvent event) {
		IResourceDelta[] affectedChildren = event.getDelta().getAffectedChildren();
		for (int i = 0; i < affectedChildren.length; i++) {
			IProject project = (IProject) affectedChildren[i].getResource();
			IResourceChangeListenerProxyNode node = (IResourceChangeListenerProxyNode) projectToProxyMap.get(project);
			if (node != null) {
				Object lowestChange = node.resourceChanged(affectedChildren[i]);
                //- if the type provider proxy node has no longer child, remove it from the project.
                if(node.getChildren().length == 0) {
                    lowestChange = project;
                    projectToProxyMap.remove(project);
                }
				if (lowestChange != null) {
					refresher.nodeChanged(lowestChange);
				}
			} else if (affectedChildren[i].getKind() == IResourceDelta.ADDED) {
                //- if there is something added to this project, refresh it this can lead to type provider appearance
                refresher.nodeChanged(project);
            }
		}
	}

    public void dispose() {
        FileProxyNodeCache.getInstance().removeResourceListener(this);
    }
	
}
