/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JavaElementProxyNode.java,v 1.5 2007/06/01 14:51:54 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.models.common.util.IDisposable;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IExtendedProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;

/**
 * Proxy node representing a java element.
 * @author jcanches
 * @since 4.3
 */
public abstract class JavaElementProxyNode implements IJavaElementChangedListenerProxyNode, IExtendedProxyNode, IDisposable {

	protected static final JavaElementProxyNode[] NO_CHILDREN = new JavaElementProxyNode[0];

	private Object parent;
	private IJavaElement element;
	
	protected JavaElementProxyNode(IJavaElement element, Object parent) {
		this.parent = parent;
		this.element = element;
	}
	
	public IProxyNode[] getChildren() {
		return NO_CHILDREN;
	}

	public Object getParent() {
		return parent;
	}

	public String getText() {
		return element.getElementName();
	}

	public Object getAdapter(Class adapter) {
		if (adapter.isAssignableFrom(element.getClass())) {
			return element;
		}
		try {
			IResource res = element.getCorrespondingResource();
			if (adapter.isAssignableFrom(res.getClass())) {
				return res;
			}
		} catch (JavaModelException e) {
			return null;
		}
		return null;
	}

	public String getIdentifier() {
		return element.getHandleIdentifier();
	}

	public IResource getUnderlyingResource() {
		return element.getResource();
	}
	
	public IJavaElement getJavaElement() {
		return element;
	}
	
	protected RegularJUnitProvider getProvider() {
		if (parent instanceof JavaElementProxyNode) {
			return ((JavaElementProxyNode)parent).getProvider();
		}
		return null;
	}

	public IResource getCorrespondingResource() {
		try {
			return element.getCorrespondingResource();
		} catch (JavaModelException e) {
			return null;
		}
	}
	
}
