/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RegularJUnitFileProxyFactory.java,v 1.3 2007/05/02 19:36:08 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard.SourcePage;
import org.eclipse.hyades.test.ui.navigator.IPersistableFileProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IMemento;

public class RegularJUnitFileProxyFactory implements IPersistableFileProxyFactory {

	public final static String ID = ToolsUiPlugin.getID() + ".regularJUnitTestSuiteFactory"; //$NON-NLS-1$
	
	public IProxyNode create(IFile file, Object parent) {
		ICompilationUnit cu = JavaCore.createCompilationUnitFrom(file);
		if (isJUnitScript(cu)) {
			return new RegularJUnitTestSuiteProxyNode(cu, parent);
		}
		return null;
	}

	public IProxyNode recreate(IMemento memento, IFile file, Object parent) {
		ICompilationUnit cu = JavaCore.createCompilationUnitFrom(file);
		return new RegularJUnitTestSuiteProxyNode(memento, cu, parent);
	}

	/**
	 * Returns whether the given java element is a JUnit test script
	 * @param cu A compilation unit.
	 * @return whether the given java element is a JUnit test script
	 */
	public static boolean isJUnitScript(ICompilationUnit cu) {
		if (!cu.exists()) return false;
		IType mainType = cu.findPrimaryType();
		try {
			if (mainType != null) {
				if (SourcePage.isTestImplementor(mainType)) {
					// Has a TestSuite already been defined for this type?
					return true;
				}
			}
		} catch (JavaModelException e) {
			ToolsUiPlugin.logError(e);
		}
		return false;
	}
	
}
