/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: RegularJUnitPackageProxyNode.java,v 1.3 2006/10/27 18:59:22 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import java.util.ArrayList;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.tools.ui.java.internal.JavaMessages;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.RegularJUnitProvider.BasicJavaElementChangeDelta;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.ui.ISharedImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.graphics.Image;

/**
 * Proxy node for a package. This proxy contains all JUnit test found in the corresponding java package.
 * @author jcanches
 * @since 4.3
 */
public class RegularJUnitPackageProxyNode extends JavaParentElementProxyNode {
    
    public static RegularJUnitPackageProxyNode create(IPackageFragment fragment, Object parent, IJavaElementDelta delta) {
        RegularJUnitPackageProxyNode proxy = new RegularJUnitPackageProxyNode(fragment, parent, delta);
        if(proxy.getChildren().length > 0) {
            return proxy;
        }
        return null;
    }
    
    private RegularJUnitPackageProxyNode(IPackageFragment fragment, Object parent, IJavaElementDelta delta) {
    	super(fragment, parent, delta);
    }
    
    public IPackageFragment getPackageFragment() {
    	return (IPackageFragment)getJavaElement();
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.navigator.IProxyNode#getText()
     */
    public String getText() {
    	String name = getJavaElement().getElementName();
    	if ("".equals(name)) { //$NON-NLS-1$
    		name = JavaMessages.DEFAULT_PACKAGE;
    	}
        return name;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.navigator.IProxyNode#getImage()
     */
    public Image getImage() {
        return JavaUI.getSharedImages().getImage(ISharedImages.IMG_OBJS_PACKAGE);
    }

	protected JavaElementProxyNode createChildProxy(IJavaElement childElement, IJavaElementDelta delta) {
		if (childElement instanceof ICompilationUnit) {
			ICompilationUnit cu = (ICompilationUnit)childElement;
			RegularJUnitProvider provider = getProvider();
			if (provider != null) {
				IProxyNode node;
				if (delta != null) {
					node = provider.fileProxyManager.updateProxy((IFile)cu.getResource(), this);
				} else {
					node = provider.fileProxyManager.getProxy((IFile)cu.getResource(), this);
				}
				if (node != null && node instanceof JavaElementProxyNode) {
					provider.fileProxyManager.cacheProxy((IFile)cu.getResource(), node);
					return (JavaElementProxyNode)node;
				}
			}
			return null;
		}
		return null;
	}
	
//	protected void disposeChildProxy(JavaElementProxyNode child) {
//		// Here we should unlink this proxy and its child in the FileProxyManager
//		// (but we need to wait for FileProxyManager API being refactored)
//		super.disposeChildProxy(child);
//	}

	protected void removeChildProxy(JavaElementProxyNode proxy) {
		getProvider().fileProxyManager.uncacheProxy((IFile)proxy.getUnderlyingResource());
		super.removeChildProxy(proxy);
	}
	
    protected IProxyNode childChanged(IJavaElementDelta delta, JavaElementProxyNode child) {
    	int flags = delta.getFlags();
		if ((flags & IJavaElementDelta.F_PRIMARY_RESOURCE) != 0) {
			IJavaElement element = delta.getElement();
			JavaElementProxyNode newProxy = null;
			if (element.getResource().exists()) {
				// Oddly enough, JDT sends a change event when a compilation unit is deleted,
				// so we need to check against this situation.
				newProxy = (JavaElementProxyNode) getProvider().fileProxyManager.updateProxy((IFile) element.getResource(), this);
			}
			if (newProxy == null) {
				removeChildProxy(child);
			} else {
				replaceChildProxy(child, newProxy);
			}
			return this;
		}
		if ((flags & BasicJavaElementChangeDelta.F_TEST_SUITE_ATTACHED) != 0
			|| (flags & BasicJavaElementChangeDelta.F_TEST_SUITE_DETACHED) != 0) {
			((RegularJUnitTestSuiteProxyNode)child).computeChildren();
			return this;
		}
    	return null;
    }

    /*
     * (non-Javadoc)
     * This implementation filters the children to exclude
     * those of type AttachedJUnitTestSuite.
     * @see org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.JavaParentElementProxyNode#getChildren()
     */
	public IProxyNode[] getChildren() {
		IProxyNode[] children = super.getChildren();
		if (children.length == 0) return children;
		ArrayList list = new ArrayList(children.length);
		for (int i = 0; i < children.length; i++) {
			RegularJUnitTestSuiteProxyNode pn = (RegularJUnitTestSuiteProxyNode)children[i];
			if (pn.isDetached()) {
				list.add(pn);
			}
		}
		return (IProxyNode[])list.toArray(new IProxyNode[list.size()]);
	}
    
}
