/*******************************************************************************
 * Copyright (c) 2006, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RegularJUnitProviderProxyNode.java,v 1.7 2010/05/21 15:28:49 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderProxyNode;
import org.eclipse.hyades.ui.extension.IAssociationConstants;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/** 
 * <p>Root of the proxy nodes hierarchy for regular JUnit tests.</p>
 * 
 * 
 * @author  Julien Canches
 * @author  Paul Slauenwhite
 * @version May 21, 2010
 * @since   September 1, 2006
 */
public class RegularJUnitProviderProxyNode extends JavaParentElementProxyNode implements ITypeProviderProxyNode {

	private String name;
	private String imageKey;
	private RegularJUnitProvider provider;
	
	public RegularJUnitProviderProxyNode(RegularJUnitProvider provider, IJavaProject project, String type, Object parent) {
		super(project, parent, true);
		this.provider = provider;
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
        IAssociationMapping associationMapping = registry.getAssociationMapping(IAssociationConstants.EP_TYPE_DESCRIPTIONS);
        IAssociationDescriptor descriptor = associationMapping.getDefaultAssociationDescriptor(type);

        this.name = TestNavigator.getTypeProviderManager().getNameFor(type);
        this.imageKey = TestNavigator.getTypeProviderManager().getImageKeyFor(type);
        
        if ((this.name == null) || (this.name.trim().length() == 0)){

        	if(descriptor != null) {
        		this.name = descriptor.getName();
        	}
        	else {
        		this.name = "[Invalid Descriptor]"; //$NON-NLS-1$
        	}
        }
        
        setChildren(computeChildren());
	}
	
	protected JavaElementProxyNode createChildProxy(IJavaElement childElement, IJavaElementDelta delta) {
		if (childElement instanceof IPackageFragmentRoot) {
			return RegularJUnitSourceFolderProxyNode.create((IPackageFragmentRoot)childElement, this, delta);
		}
		return null;
	}
	
//	private boolean isSourceFolder() {
//		if (children.length == 1) {
//			return ((RegularJUnitSourceFolderProxyNode)children[0]).isProjectRoot();
//		}
//		return false;
//	}
	
	public IJavaProject getJavaProject() {
		return (IJavaProject)getJavaElement();
	}
	
	public Image getImage() {
        if(this.imageKey == null || this.imageKey.length() == 0) {
        	return PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_OBJ_FOLDER);
        } else {
            return UiPlugin.getInstance().getImageRegistry().get(this.imageKey);
        }
    }

	public String getText() {
        return name;
	}

	public IProxyNode elementChanged(IJavaElementDelta delta) {
		if (delta.getKind() == IJavaElementDelta.CHANGED) {
			IJavaElementDelta[] deltas = delta.getAffectedChildren();
			IProxyNode lowestChanged = null;
			for (int i = 0; i < deltas.length; i++) {
				IProxyNode lowestChild = null;
				IJavaElementDelta childDelta = deltas[i];
				IJavaElement elem = childDelta.getElement();
				if (elem.getElementType() == IJavaElement.PACKAGE_FRAGMENT_ROOT) {
					if (childDelta.getKind() == IJavaElementDelta.ADDED
						|| (childDelta.getKind() == IJavaElementDelta.CHANGED
							&& (childDelta.getFlags() & IJavaElementDelta.F_ADDED_TO_CLASSPATH) > 0)) {
						lowestChild = packageFragmentRootAdded((IPackageFragmentRoot)elem, childDelta);
					} else if (childDelta.getKind() == IJavaElementDelta.REMOVED
							   || (childDelta.getKind() == IJavaElementDelta.CHANGED
								   && (childDelta.getFlags() & IJavaElementDelta.F_REMOVED_FROM_CLASSPATH) > 0)) {
						lowestChild = packageFragmentRootRemoved((IPackageFragmentRoot)elem);
					} else if (childDelta.getKind() == IJavaElementDelta.CHANGED
							   && (childDelta.getFlags() & IJavaElementDelta.F_CHILDREN) > 0) {
						lowestChild = packageFragmentRootChanged((IPackageFragmentRoot)elem, childDelta);
					}
				}
				if (lowestChild != null) {
	                if(lowestChanged == null) {
	                    lowestChanged = lowestChild;
	                } else {
	                    lowestChanged = this;
	                }
				}
			}
			return lowestChanged;
		}
		return null;
	}

	private IProxyNode packageFragmentRootAdded(IPackageFragmentRoot root, IJavaElementDelta delta) {
		RegularJUnitSourceFolderProxyNode proxy = RegularJUnitSourceFolderProxyNode.create(root, this, delta);
		if (proxy != null) {
			addChildProxy(proxy);
			return this;
		}
		return null;
	}

	private IProxyNode packageFragmentRootRemoved(IPackageFragmentRoot root) {
		JavaElementProxyNode proxy = getChildProxy(root);
		if (proxy != null) {
			removeChildProxy(proxy);
			return this;
		}
		return null;
	}
	
	private IProxyNode packageFragmentRootChanged(IPackageFragmentRoot root, IJavaElementDelta delta) {
		JavaElementProxyNode proxy = getChildProxy(root);
		if (proxy != null) {
			IProxyNode lowestChanged  = proxy.elementChanged(delta);
			if (proxy.getChildren().length == 0) {
				removeChildProxy(proxy);
				return this;
			}
			return lowestChanged;
		} else {
			proxy = RegularJUnitSourceFolderProxyNode.create(root, this, delta);
			if (proxy != null) {
				addChildProxy(proxy);
				return this;
			}
		}
		return null;
	}

	protected RegularJUnitProvider getProvider() {
		return provider;
	}

//	public IProxyNode[] getChildren() {
//		if (isSourceFolder()) {
//			return children[0].getChildren();
//		}
//		return super.getChildren();
//	}

	
	
}
