/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RegularJUnitSourceFolderProxyNode.java,v 1.4 2007/05/02 19:36:08 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ui.ISharedImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.graphics.Image;

/**
 * Proxy node for a source folder. This proxy represents a package fragment root,
 * and has package proxy as children.
 * @author jcanches
 * @since 4.3
 */
public class RegularJUnitSourceFolderProxyNode extends JavaParentElementProxyNode {

	private boolean isProjectRoot;
	
	public static RegularJUnitSourceFolderProxyNode create(IPackageFragmentRoot root, Object parent, IJavaElementDelta delta) {
		if (root.isArchive()) return null;
		RegularJUnitSourceFolderProxyNode proxy = new RegularJUnitSourceFolderProxyNode(root, parent, delta);
		if (proxy.getChildren().length == 0) {
			return null;
		}
		return proxy;
	}
	
	private RegularJUnitSourceFolderProxyNode(IPackageFragmentRoot root, Object parent, IJavaElementDelta delta) {
		super(root, parent, delta);
		isProjectRoot = root.getPath().equals(root.getJavaProject().getPath());
	}

    public Image getImage() {
		return JavaUI.getSharedImages().getImage(ISharedImages.IMG_OBJS_PACKFRAG_ROOT);
	}

	protected JavaElementProxyNode createChildProxy(IJavaElement childElement, IJavaElementDelta delta) {
		if (childElement instanceof IPackageFragment) {
			return RegularJUnitPackageProxyNode.create((IPackageFragment)childElement, this, delta);
		}
		return null;
	}
	
	public boolean isProjectRoot() {
		return isProjectRoot;
	}

	public String getText() {
		if (isProjectRoot) {
			// This is a debug-only string as this text should never be presented to the user.
			return "[project root]"; //$NON-NLS-1$
		}
		return super.getText();
	}
	
}
