/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RegularJUnitTestCaseProxyNode.java,v 1.4 2007/05/02 19:36:08 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.tools.core.common.TestCommon;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.hyades.ui.extension.IAssociationConstants;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public class RegularJUnitTestCaseProxyNode implements ITestCaseProxyNode {

	private RegularJUnitTestSuiteProxyNode parent;
	private String name;
	private String id;
	
	public RegularJUnitTestCaseProxyNode(ITestCase testCase, RegularJUnitTestSuiteProxyNode parent) {
		this.parent = parent;
		this.name = testCase.getName();
		this.id = testCase.getId();
	}
	
	/*package*/ RegularJUnitTestCaseProxyNode(IMemento memento, RegularJUnitTestSuiteProxyNode parent) {
		this.parent = parent;
		this.name = memento.getString("name"); //$NON-NLS-1$
		this.id = memento.getString("id"); //$NON-NLS-1$
	}
	
	public TPFTestCase getTestCase() {
		RegularJUnitTestSuiteProxyNode tsPn = (RegularJUnitTestSuiteProxyNode)getParent();
		TPFTestSuite ts = tsPn.getTestSuite();
		return (TPFTestCase) ts.eResource().getEObject(id);
	}

	public String getType() {
		return TestCommon.OTHER_JUNIT_TEST_CASE_TYPE;
	}

	public IProxyNode[] getChildren() {
		return new IProxyNode[0];
	}

	public Image getImage() {
		AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestCaseMappingRegistry();
		IAssociationMapping associationMapping = registry.getAssociationMapping(IAssociationConstants.EP_TYPE_DESCRIPTIONS);
		IAssociationDescriptor descriptor = associationMapping.getDefaultAssociationDescriptor(getType());	
		if(descriptor != null) {
			return descriptor.getImage();
		} else {
			//- the type of this element wasn't registered by any extension (hyades.ui.typeDescriptions)
			return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_TEST_CASE);
		}
	}

	public Object getParent() {
		return parent;
	}

	public String getText() {
		return name;
	}

	public Object getAdapter(Class adapter) {
		// TODO Auto-generated method stub
		return null;
	}

	public String getIdentifier() {
		return id;
	}

	public IResource getUnderlyingResource() {
		return parent.getUnderlyingResource();
	}

	public void saveState(IMemento memento) {
		memento.putString("name", name); //$NON-NLS-1$
		memento.putString("id", id); //$NON-NLS-1$
	}

}
