/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RegularJUnitTestSuiteProxyNode.java,v 1.5 2007/05/03 01:33:00 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.JUnitModelUpdater;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.JUnitResourceFactory;
import org.eclipse.hyades.test.tools.core.internal.java.preferences.JUnitTestSuiteFactoryOptions;
import org.eclipse.hyades.test.tools.core.java.JUnitTestSuiteFacade;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.ui.ISharedImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public class RegularJUnitTestSuiteProxyNode extends JavaElementProxyNode implements ITestSuiteProxyNode, IPersistableProxyNode {

	private IProxyNode[] children;

	/*package*/ RegularJUnitTestSuiteProxyNode(ICompilationUnit cu, Object parent) {
		super(cu, parent);
		computeChildren();
	}
	
	/*package*/ RegularJUnitTestSuiteProxyNode(IMemento memento, ICompilationUnit cu, Object parent) {
		super(cu, parent);
		IMemento[] children = memento.getChildren("testCase"); //$NON-NLS-1$
		this.children = new IProxyNode[children.length];
		for (int i = 0; i < children.length; i++) {
			this.children[i] = new RegularJUnitTestCaseProxyNode(children[i], this);
		}
	}
	
	/**
	 * Returns whether this JUnit compilation unit is attached to a persisted test suite
	 * model.
	 * @return whether this JUnit compilation unit is attached to a persisted test suite
	 * model.
	 */
	public boolean isDetached() {
		try {
			return JUnitModelUpdater.findTestSuiteFile((IFile) getCompilationUnit().getResource()) == null;
		} catch (CoreException e) {
			return true;
		}
	}
	
	/*package*/ void computeChildren() {
		ITestSuite testSuite = getTestSuite();
		if (testSuite == null) {
			this.children = new IProxyNode[0];
			return;
		}
		List _children = new ArrayList(testSuite.getITestCases().size());
		Iterator it = testSuite.getITestCases().iterator();
		while (it.hasNext()) {
			ITestCase tc = (ITestCase) it.next();
			IProxyNode proxy = new RegularJUnitTestCaseProxyNode(tc, this);
			_children.add(proxy);
		}
		this.children = (IProxyNode[])_children.toArray(new IProxyNode[_children.size()]);
	}
	
	public ICompilationUnit getCompilationUnit() {
		return (ICompilationUnit)getJavaElement();
	}
	
	public TPFTestSuite getTestSuite() {
		TPFTestSuite ts = JUnitModelUpdater.findTestSuite(getCompilationUnit().findPrimaryType(), new ResourceSetImpl());
		if (ts == null) {
			try {
				ts = (TPFTestSuite) JUnitTestSuiteFacade.createTestSuite(getCompilationUnit(), getType());
			} catch (CoreException e) {
				ToolsUiPlugin.logError(e);
				ts = null;
			}
		}
		return ts;
	}
	
	public String getType() {
		return JUnitTestSuiteFactoryOptions.getDefaultJUnitTestSuiteType(getCompilationUnit());
	}

	public IProxyNode[] getChildren() {
		return children;
	}

	public Image getImage() {
		return JavaUI.getSharedImages().getImage(ISharedImages.IMG_OBJS_CUNIT);
	}

	public IProxyNode elementChanged(IJavaElementDelta delta) {
		// Never invoked
		return null;
	}
	
	public String getFactoryID() {
		return RegularJUnitFileProxyFactory.ID;
	}

	public boolean saveState(IMemento memento) {
		for (int i = 0; i < children.length; i++) {
			IMemento child = memento.createChild("testCase"); //$NON-NLS-1$
			((RegularJUnitTestCaseProxyNode)children[i]).saveState(child);
		}
		return true;
	}
	
	public void dispose() {
		// NOP
	}

	public String getIdentifier() {
		return JUnitResourceFactory.ROOT_ID;
	}

}
