/*******************************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitPreferencesPage.java,v 1.7 2009/05/19 02:26:26 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.java.internal.JavaMessages;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.controls.CodeUpdatePreviewOptionsGroup;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.controls.JUnitTestSuiteImportOptionsControl;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/**
 * <p>JUnitPreferencesPage.java</p>
 * 
 * 
 * @author  Paul Slauenwhite
 * @version May 18, 2009
 * @since   August 10, 2006
 */
 public class JUnitPreferencesPage extends PreferencePage implements IWorkbenchPreferencePage {

	private CodeUpdatePreviewOptionsGroup previewOptions;
	private JUnitTestSuiteImportOptionsControl importOptions;
	
	protected IPreferenceStore getCorePreferences() {
		return new ScopedPreferenceStore(new InstanceScope(), CorePlugin.PLUGIN_ID);
	}
	
	public JUnitPreferencesPage() {
		setPreferenceStore(ToolsUiPlugin.getDefault().getPreferenceStore());
	}
	
	protected Control createContents(Composite parent) {

		GridLayout compositePaneGroupGridLayout = new GridLayout(1, true);		
		compositePaneGroupGridLayout.marginWidth = compositePaneGroupGridLayout.marginHeight = 0;
		compositePaneGroupGridLayout.horizontalSpacing = compositePaneGroupGridLayout.verticalSpacing = 5;
		
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(compositePaneGroupGridLayout);
		
		previewOptions = new CodeUpdatePreviewOptionsGroup(composite, SWT.NONE);
		previewOptions.initialize(getPreferenceStore());
		
		Group optionsGroup = new Group(composite, SWT.NONE);
		optionsGroup.setText(JavaMessages.JUNIT_PREFERENCE_TESTS_IMPORT_GROUP);
		optionsGroup.setLayout(new GridLayout(1, false));
		optionsGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		Label label = new Label(optionsGroup, SWT.WRAP);
		label.setText(JavaMessages.JUNIT_PREFERENCE_DEFAULT_OPTIONS_DESCR);
		
		importOptions = new JUnitTestSuiteImportOptionsControl(optionsGroup, SWT.NONE);
		importOptions.initialize(getCorePreferences(), null);
		importOptions.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false));

		Dialog.applyDialogFont(composite);
		
		return composite;
	}
		
	public boolean performOk() {
		previewOptions.save(getPreferenceStore());
		importOptions.save(getCorePreferences());
		return true;
	}
	
	protected void performDefaults() {
		previewOptions.resetToDefaults(getPreferenceStore());
		importOptions.resetToDefaults(getCorePreferences());
		super.performDefaults();
	}

	public void init(IWorkbench workbench) {
		// NOP
	}

}
