/*******************************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitUIPreferences.java,v 1.4 2009/05/19 02:26:25 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;

/**
 * <p>Preferences constants for JUnit UI preferences.</p>
 * 
 * 
 * @author  Julien Canches
 * @author  Paul Slauenwhite
 * @version May 18, 2009
 * @since   August 10, 2006
 */
 public class JUnitUIPreferences extends AbstractPreferenceInitializer {

	public final static String CODE_UPDATE_PREVIEW_MODE = "code.update.preview.mode"; //$NON-NLS-1$
	public final static int ALWAYS_PREVIEW = 0;
	public final static int DESTRUCTIVE_CHAGES_PREVIEW = 1;
	public final static int NEVER_PREVIEW = 2;
	public final static int PROMPT_PREVIEW = 3;
	
	public void initializeDefaultPreferences() {
		ToolsUiPlugin.getDefault().getPluginPreferences().setDefault(CODE_UPDATE_PREVIEW_MODE, PROMPT_PREVIEW);
	}
}
