/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitContainerPropertyPage.java,v 1.3 2007/05/02 19:36:08 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.property;

import java.io.IOException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.java.internal.JavaMessages;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.controls.JUnitTestSuiteImportOptionsControl;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class JUnitContainerPropertyPage extends PropertyPage implements IWorkbenchPropertyPage {

	private JUnitTestSuiteImportOptionsControl importOptions;

	public JUnitContainerPropertyPage() {
		super();
		//setTitle("JUnit Properties"); // Not taken into account by the container
		setDescription(JavaMessages.JUNIT_PREFERENCE_DEFAULT_OPTIONS_DESCR);
	}

	protected Control createContents(Composite parent) {
		importOptions = new JUnitTestSuiteImportOptionsControl(parent, SWT.NONE);
		initialize();
		return importOptions;
	}

	protected void initialize() {
		IProject project = (IProject) getElement().getAdapter(IProject.class);
		IScopeContext scope = new ProjectScope(project);
		setPreferenceStore(new ScopedPreferenceStore(scope, CorePlugin.PLUGIN_ID));
		importOptions.initialize(getPreferenceStore(), project);
	}
	
	protected void performApply() {
		importOptions.save(getPreferenceStore());
		try {
			((ScopedPreferenceStore)getPreferenceStore()).save();
		} catch (IOException e) {
			ToolsUiPlugin.logError(e);
		}
		super.performApply();
	}

	protected void performDefaults() {
		importOptions.resetToDefaults(getPreferenceStore());
		super.performDefaults();
	}

}
