/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AdjustSourceInfoPage.java,v 1.11 2009/05/04 16:25:53 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.test.core.util.JavaUtil;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.editor.SourceInfoViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.widgets.Composite;

/**
 * <p>AdjustSourceInfoPage.java</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version April 30, 2009
 * @since   February 1, 2005
 * @deprecated The Generate wizard has been removed and is replaced by an auto-sync
 * feature between the Test model and the code.
 */
public class AdjustSourceInfoPage 
extends WizardPage
{
	private IImplementor implementor;
	private SourceInfoViewer sourceInfoViewer;
	
	/**
	 * Constructor for AdjustSourceInfoPage
	 * @param pageName
	 */
	public AdjustSourceInfoPage(IImplementor implementor)
	{
		super("AdjustSourceInfoPage"); //$NON-NLS-1$
		setTitle(ToolsUiPluginResourceBundle.JAVA_GEN_WTITLE); 
		setDescription(ToolsUiPluginResourceBundle.ADJ_PG_DSC); 

		this.implementor = implementor;
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#dispose()
	 */
	public void dispose()
	{
		implementor = null;
		sourceInfoViewer.dispose();
		super.dispose();
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent)
	{
		sourceInfoViewer = new SourceInfoViewer()
		{
			public void modifyText(ModifyEvent e)
			{
				super.modifyText(e);
				setPageComplete(validatePage());
			}	
		};
		Composite composite = sourceInfoViewer.createClient(parent, null, null);
		setControl(composite);
		
		sourceInfoViewer.setInput(implementor);
		sourceInfoViewer.setInitialFocus();
		
		setPageComplete(validatePage());
		setErrorMessage(null);
	}
	
	protected boolean validatePage(){
				
		//Source folder validation:
		String errorMessage = JavaUtil.validateSourceFolder(sourceInfoViewer.getSourceFolder());
		
		if (errorMessage != null){
			
			setErrorMessage(errorMessage);
			
			return false;
		} 
		
		//Package name validation:
		errorMessage = JavaUtil.validatePackageName(sourceInfoViewer.getPackage());
		
		if (errorMessage != null){
			
			setErrorMessage(errorMessage);
			
			return false;
		}
		
		//Class name validation:
		errorMessage = JavaUtil.validateClassName(sourceInfoViewer.getClassName());
		
		if (errorMessage != null){
			
			setErrorMessage(errorMessage);
			
			return false;
		}

		setErrorMessage(null);
		
		return true;
	}
}
