/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GenerateWizard.java,v 1.20 2009/05/04 16:25:53 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.AutomaticDependencyUpdater;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.Generator;
import org.eclipse.hyades.test.tools.core.internal.java.codegen.JUnitGenerator;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.TestCommonImages;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

/**
 * <p>GenerateWizard.java</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version April 30, 2009
 * @since   February 1, 2005
 * @deprecated The Generate wizard has been removed and is replaced by an auto-sync
 * feature between the Test model and the code.
 */
public class GenerateWizard 
extends HyadesWizard implements IRunnableWithProgress
{
	public final static String PLUGIN_ID_JUNIT = "org.junit"; //$NON-NLS-1$
	public final static String PLUGIN_ID_EXECUTION_CORE = "org.eclipse.hyades.execution.core"; //$NON-NLS-1$
	public final static String PLUGIN_ID_EXECUTION_REMOTE = "org.eclipse.hyades.execution.remote"; //$NON-NLS-1$

	private ITestSuite testSuite;
	private AdjustSourceInfoPage adjustSourceInfoPage;

	/**
	 * Constructor for GenerateWizard
	 */
	public GenerateWizard()
	{
		super();

		setWindowTitle(ToolsUiPluginResourceBundle.JAVA_GEN_WTITLE); 
		setDefaultPageImageDescriptor(TestCommonImages.INSTANCE.getImageDescriptor(TestCommonImages.IMG_WIZBAN_GENERATE));

		IDialogSettings dialogSettings = ToolsUiPlugin.getDefault().getDialogSettings();
		IDialogSettings settings = dialogSettings.getSection("junit.GenerateWizard"); //$NON-NLS-1$
		if (settings == null)
			settings = dialogSettings.addNewSection("junit.GenerateWizard"); //$NON-NLS-1$
		setDialogSettings(settings);
	}

	public ITestSuite getTestSuite()
	{
		return testSuite;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
	 */
	protected void initPages()
	{
		IStructuredSelection structuredSelection = getSelection();
		if(structuredSelection.size() == 1)
		{
			Object selection = structuredSelection.getFirstElement();
			if(selection instanceof ITestSuite) {
				testSuite = (ITestSuite)selection;
			} else if (selection instanceof ITestSuiteProxyNode) {
				ITestSuiteProxyNode tsProxy = (ITestSuiteProxyNode) selection;
				//- load the test suite from the proxy
				testSuite = tsProxy.getTestSuite();
			}
		}
		
		adjustSourceInfoPage = new AdjustSourceInfoPage(getTestSuite().getImplementor());
	}

	/**
	 * @see org.eclipse.jface.wizard.Wizard#addPages()
	 */
	public void addPages()
	{
		if(adjustSourceInfoPage != null)
			addPage(adjustSourceInfoPage);
	}

	public void run(IProgressMonitor mon)
	throws InterruptedException, InvocationTargetException
	{
		if(getTestSuite() != null)
		{							
			Resource resource = ((EObject)getTestSuite()).eResource();
			boolean isTrackingModification = resource.isTrackingModification();
			resource.setTrackingModification(true);
			resource.setModified(adjustSourceInfoPage != null);
			
			Generator generator = createGenerator();
			if(generator.getFileHandle(getTestSuite()).exists())
			{
				MessageDialog dialog = new MessageDialog(
				getShell(), UiPluginResourceBundle.W_QUESTION,  
				null, ToolsUiPluginResourceBundle.Q_OVR_FILE,  
				MessageDialog.QUESTION, 
				new String[] {IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1); 

				if(dialog.open() != IDialogConstants.OK_ID)
				{
					mon.setCanceled(true);
					throw new InterruptedException();
				}
			}
				
			try
			{
				Change change = generator.createChange(new NullProgressMonitor());
				change.perform(new NullProgressMonitor());
			}
			catch(Exception e)
			{
				ToolsUiPlugin.logError(e);
				throw new InvocationTargetException(e);
			}
			
			if(resource.isModified())
			{
				try
				{
					EMFUtil.save(resource);
				}
				catch (Exception e)
				{
					ToolsUiPlugin.logError(e);
				}
			}
			resource.setTrackingModification(isTrackingModification);
		}
	}

	public boolean performFinish()
	{
		IRunnableWithProgress op = new WorkspaceModifyDelegatingOperation(this);
		try
		{
			getContainer().run(false, true, op);
		}
		catch(InvocationTargetException e)
		{
			MessageDialog.openError(getShell(), UiPluginResourceBundle.W_ERROR, e.getTargetException().getMessage()); 
			return false;
		}
		catch (InterruptedException e)
		{
			return false;
		}

		return true;
	}
	
	protected Generator createGenerator()
	{
		return new JUnitGenerator(getTestSuite(), new AutomaticDependencyUpdater());
	}
}