/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitImportWizard.java,v 1.18 2010/05/21 15:28:49 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.tools.core.java.JUnitTestSuiteFacade;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.TestJavaImages;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/**
 * <p>JUnit import wizard.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version May 21, 2010
 * @since   March 25, 2005
 */
public class JUnitImportWizard extends Wizard implements IImportWizard {
    private JUnitScriptsSelectionPage page1;
    private IStructuredSelection selection;

    /**
     *
     */
    public JUnitImportWizard() {
        setDefaultPageImageDescriptor(TestJavaImages.INSTANCE.getImageDescriptor(TestJavaImages.IMG_WIZBAN_IMPORT_JUNIT_TESTSUITE));
        setWindowTitle(ToolsUiPluginResourceBundle.JUnitImportWizard_title); 
        setNeedsProgressMonitor(true);
    }

    /**
     * @see Wizard#performFinish
     */
    public boolean performFinish() {
    	page1.saveDialogSettings();
        final List junitScripts = page1.getSelectedElements();
        final String type = page1.getSelectedType();
        IRunnableWithProgress operation = new WorkspaceModifyOperation() {
            public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    monitor.beginTask("", junitScripts.size()); //$NON-NLS-1$
                    
                    for (Iterator it = junitScripts.iterator(); it.hasNext();) {
                        Object object = it.next();
                        //- by construction all elements checked should be of type ICompilationUnit
                        if (object instanceof ICompilationUnit) {
                            ICompilationUnit cu = (ICompilationUnit) object;
                            generateTest(type, cu, new SubProgressMonitor(monitor, 1, SubProgressMonitor.PREPEND_MAIN_LABEL_TO_SUBTASK));
                            
                       		String testSuiteName = cu.getElementName();
                    		testSuiteName = testSuiteName.substring(0, testSuiteName.indexOf('.'));

                			//Attempt to open the editor:
                			TestUIUtil.openEditor(((IFile)(cu.getCorrespondingResource()))
                    				.getParent()
                    				.getFile(new Path(testSuiteName + "." + ICommonConstants.TEST_SUITE_FILE_EXTENSION)), TestUIExtension.GENERIC_TEST_SUITE_EDITOR_PART_ID); //$NON-NLS-1$
                        } else {
                        	ToolsUiPlugin.logError("Returned element of JUnit scripts selection page should be a Compilation Unit"); //$NON-NLS-1$
                        }
                    }
                } catch (Exception e) {
                    throw new InvocationTargetException(e);
                } finally {
                    monitor.done();
                }
            }
        };
        try {
            getContainer().run(false, false, operation);
        } catch (InvocationTargetException e) {
        	ToolsUiPlugin.logError(e);
        } catch (InterruptedException e) {
            //- does not occur because operation is not cancellable
        }
        return true;
    }

    /**
     * @param project
     * @param overwrite
     */
    protected void generateTest(String type, ICompilationUnit cu, SubProgressMonitor monitor) {
        monitor.beginTask(NLS.bind(ToolsUiPluginResourceBundle.GENERATING_LABEL, (new Object[]{ cu.getElementName()})), 1); 
        try {
        	JUnitTestSuiteFacade.createTestSuite(cu, type, /*force*/false);
        } catch (CoreException e) {
			UiPlugin.logError(e);
		} finally {
            monitor.worked(1);
            monitor.done();
        }
    }
    
    /**
     * @see Wizard#init
     */
    public void init(IWorkbench wb, IStructuredSelection sel) {
        this.selection = sel;
    }

    public void addPages() {
        page1 = createJUnitScriptsSelectionPage();
        page1.init(selection);
        addPage(page1);
    }
    
    protected JUnitScriptsSelectionPage createJUnitScriptsSelectionPage() {
    	return new JUnitScriptsSelectionPage();
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.wizard.IWizard#canFinish()
     */
    public boolean canFinish() {
        return super.canFinish();
    }

}