/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitScriptsSelectionPage.java,v 1.10 2009/03/27 17:10:34 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.JUnitExtensionsRegistry;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor;
import org.eclipse.hyades.test.tools.core.internal.java.preferences.JUnitTestSuiteFactoryOptions;
import org.eclipse.hyades.test.tools.core.java.IJUnitTestSuiteFactory;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.JavaMessages;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.controls.JUnitTestSuiteFactoriesProvider;
import org.eclipse.hyades.ui.util.TreeSelector;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

 /**
 * <p>JUnitScriptsSelectionPage.java.</p>
 * 
 * 
 * @author  Jerome Gout
 * @author  Julien Canches
 * @author  Paul E. Slauenwhite
 * @version March 27, 2009
 * @since   March 25, 2005
 */
public class JUnitScriptsSelectionPage extends WizardPage implements ICheckStateListener {

    private static final String DS_TYPE = "type"; //$NON-NLS-1$
    
	private TreeSelector selector;
    private ComboViewer testFactoryList;
    private JUnitWorkspaceContentProvider contentProvider;
    protected List initialSelection;
	
    public JUnitScriptsSelectionPage() {
    	super("JUnitScriptSelectionPage"); //$NON-NLS-1$
    	setTitle(ToolsUiPluginResourceBundle.JUnitImportWizard_title); 
    	setDescription(ToolsUiPluginResourceBundle.JUnitScriptsSelectionPage_prompt); 
    	selector = null;
    }
        
	public void createControl(Composite parent) {
        initializeDialogUnits(parent);
        Composite composite = new Composite(parent, SWT.NULL);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout(gl);
        gl.verticalSpacing = 20;
        composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
        composite.setFont(parent.getFont());
        
        Label label = new Label(composite, SWT.NONE);
        label.setText(JavaMessages.JUNIT_IMPORT_WIZARD_DESTINATION_TYPE);
        label.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));
        testFactoryList = new ComboViewer(composite, SWT.DROP_DOWN | SWT.READ_ONLY);
        JUnitTestSuiteFactoriesProvider provider = new JUnitTestSuiteFactoriesProvider();
        testFactoryList.setLabelProvider(provider);
        testFactoryList.setContentProvider(provider);
        testFactoryList.setInput(JavaCore.create(ResourcesPlugin.getWorkspace().getRoot()));
        testFactoryList.getControl().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        testFactoryList.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				IJUnitTestSuiteFactory factory = getTestSuiteFactory();
				if (factory != null) {
					contentProvider.setJUnitTestSuiteFactory(factory);
					List checkedElements;
					if (initialSelection != null) {
						checkedElements = initialSelection;
						initialSelection = null;
					} else {
						checkedElements = selector.getSelectedElements();
					}
					IJavaModel javaWorkspace = JavaCore.create(ResourcesPlugin.getWorkspace().getRoot());
					selector.setInput(null);
					selector.setInput(javaWorkspace);
					selector.setInitialCheckedElements(checkedElements);
					setPageComplete(true);
					setErrorMessage(null);
				} else {
					selector.setInput(null);
					setPageComplete(false);
					setErrorMessage(JavaMessages.JUNIT_IMPORT_WIZARD_INTERNAL_ERROR);
				}
			}
		});
        
        //- build the selection widget
        IJavaModel javaWorkspace = JavaCore.create(ResourcesPlugin.getWorkspace().getRoot());
        JavaElementLabelProvider javaLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        contentProvider = new JUnitWorkspaceContentProvider();
        selector = new TreeSelector(composite, javaWorkspace, contentProvider, javaLabelProvider, SWT.BORDER);
        contentProvider.setRunnableContext(this.getContainer());
        selector.getTreeViewer().addCheckStateListener(this);
        selector.getControl().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
        
        readDialogSettings();
        
        setPageComplete(!testFactoryList.getSelection().isEmpty());
        setControl(composite);
	}
	
	protected void init(IStructuredSelection selection) {
		Iterator it = selection.iterator();
		initialSelection = new ArrayList(selection.size());
		while (it.hasNext()) {
			Object o = it.next();
			if (o instanceof IAdaptable) {
				ICompilationUnit cu = (ICompilationUnit) ((IAdaptable)o).getAdapter(ICompilationUnit.class);
				if (cu != null) {
					initialSelection.add(cu);
				}
			}
		}
	}
	
	private static IJavaProject findEnclosingProject(List compilationUnits) {
		IJavaProject project = null;
		for (Iterator it = compilationUnits.iterator(); it.hasNext();) {
			ICompilationUnit cu = (ICompilationUnit) it.next();
			IJavaProject jp = cu.getJavaProject();
			if (project == null) {
				project = jp;
			} else {
				if (!project.equals(jp)) {
					return null;
				}
			}
		}
		return project;
	}
	
	protected IJUnitTestSuiteFactory getTestSuiteFactory() {
		ISelection selection = testFactoryList.getSelection();
		if (selection instanceof IStructuredSelection) {
			JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor descr =
				(JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor) ((IStructuredSelection)selection).getFirstElement();
			if (descr != null) {
				return descr.getFactory();
			}
		}
		return null;
	}
	
	public String getSelectedType() {
		ISelection selection = testFactoryList.getSelection();
		if (selection instanceof IStructuredSelection) {
			JUnitTestSuiteFactoryDescriptor descr =
				(JUnitTestSuiteFactoryDescriptor) ((IStructuredSelection)selection).getFirstElement();
			if (descr != null) {
				return descr.getType();
			}
		}
		return null;
	}
	
	public void setSelectedType(String type) {
		JUnitTestSuiteFactoryDescriptor descr = JUnitExtensionsRegistry.getInstance().getDescriptor(type);
		if (descr != null) {
			testFactoryList.setSelection(new StructuredSelection(descr));
		} else {
			testFactoryList.setSelection(StructuredSelection.EMPTY);
		}
	}
	
    public List getSelectedElements() {
        return selector.getSelectedElements(ICompilationUnit.class);
    }

	public void checkStateChanged(CheckStateChangedEvent event) {
		setPageComplete(selector.getSelectedElements().size() != 0);
	}
	
	protected IDialogSettings getDialogSettings() {
		IDialogSettings pluginSettings = ToolsUiPlugin.getDefault().getDialogSettings();
		IDialogSettings settings = pluginSettings.getSection(JUnitScriptsSelectionPage.class.getName());
		if (settings == null) {
			settings = pluginSettings.addNewSection(JUnitScriptsSelectionPage.class.getName());
		}
		return settings;
	}
	
	protected void readDialogSettings() {
		IJavaProject project = findEnclosingProject(initialSelection);
		String type = null;
		if (project != null) {
			type = JUnitTestSuiteFactoryOptions.getDefaultJUnitTestSuiteType(project);
		}
		if (type == null) {
			IDialogSettings settings = getDialogSettings();
			type = settings.get(DS_TYPE);
		}
		if (type != null) {
			setSelectedType(type);
		}
		if (getSelectedType() == null) {
			// Default to the first item in list
			Object o = testFactoryList.getElementAt(0);
	        if (o != null) testFactoryList.setSelection(new StructuredSelection(o));
		}
	}
	
	/*package*/ void saveDialogSettings() {
		IDialogSettings settings = getDialogSettings();
		settings.put(DS_TYPE, getSelectedType());
	}

}
