/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitTestCaseNewWizard.java,v 1.8 2009/03/27 17:10:34 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import org.eclipse.hyades.test.tools.core.common.TestCommon;
import org.eclipse.hyades.test.tools.ui.common.internal.wizard.TestCaseNewWizard;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.TestJavaImages;

/**
 * <p>Wizard for the JUnit Test Case.</p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul Slauenwhite
 * @version March 27, 2009
 * @since 	January 2, 2005
 */
public class JUnitTestCaseNewWizard
extends TestCaseNewWizard
{
	/**
	 * Constructor for TestCaseNewWizard
	 */
	public JUnitTestCaseNewWizard()
	{
		super();

		setWindowTitle(ToolsUiPluginResourceBundle.WIZ_NEW_JUNIT_TST_CASE_PG_TTL); 
		setDefaultPageImageDescriptor(TestJavaImages.INSTANCE.getImageDescriptor(TestJavaImages.IMG_WIZBAN_NEW_JUNIT_TESTCASE));
	}

	/**
	 * Returns the type for the test case created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestCommon.JUNIT_TEST_CASE_TYPE;
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages(){
		
        getNameAndDescriptionWizardPage().setTitle(ToolsUiPluginResourceBundle.WIZ_NEW_JUNIT_TST_CASE_PG_TTL); 
        getNameAndDescriptionWizardPage().setDescription(ToolsUiPluginResourceBundle.WIZ_NEW_JUNIT_TST_CASE_PG_ATT_DSC); 
        
        addPage(getNameAndDescriptionWizardPage());
	}
}
