/*******************************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: UpdateCodeWizard.java,v 1.5 2009/05/19 02:26:26 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.preferences.JUnitUIPreferences;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;

/**
 * <p>UpdateCodeWizard.java</p>
 * 
 * 
 * @author  Paul Slauenwhite
 * @version May 18, 2009
 * @since   August 10, 2006
 */
 public class UpdateCodeWizard extends RefactoringWizard {

	UpdateCodeWizardPage previewOptionsPage;
	
	public UpdateCodeWizard(Refactoring refactoring, boolean showPreview) {
		super(refactoring, computeFlags(showPreview));
	}
	
	private static int computeFlags(boolean showPreview) {
		int flags = RefactoringWizard.WIZARD_BASED_USER_INTERFACE;
		if (!showPreview) flags |= RefactoringWizard.NO_PREVIEW_PAGE;
		return flags;
	}
	
	protected void addUserInputPages() {
		previewOptionsPage = new UpdateCodeWizardPage();
		addPage(previewOptionsPage);
	}

	public IWizardPage getStartingPage() {

		if (ToolsUiPlugin.getDefault().getPluginPreferences().getInt(JUnitUIPreferences.CODE_UPDATE_PREVIEW_MODE) == JUnitUIPreferences.PROMPT_PREVIEW) {
			return super.getStartingPage();
		} 
		else {
			return super.getStartingPage().getNextPage();			
		}
	}

	public boolean performFinish() {
		previewOptionsPage.saveContent();
		return super.performFinish();
	}
	
}
