/*******************************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: UpdateCodeWizardPage.java,v 1.6 2009/05/19 02:26:26 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.controls.CodeUpdatePreviewOptionsGroup;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

/**
 * <p>UpdateCodeWizardPage.java</p>
 * 
 * 
 * @author  Paul Slauenwhite
 * @version May 18, 2009
 * @since   August 10, 2006
 */
public class UpdateCodeWizardPage extends UserInputWizardPage {

	private CodeUpdatePreviewOptionsGroup control = null;
	
	protected UpdateCodeWizardPage() {
		
		super("UpdateCodeWizardPage"); //$NON-NLS-1$
		
		setTitle(ToolsUiPluginResourceBundle.CODE_UPDATE_PREVIEW_WIZARD_PAGE_NAME); 
		setDescription(ToolsUiPluginResourceBundle.CODE_UPDATE_PREVIEW_WIZARD_PAGE_DESCRIPTION); 
	}

	public void createControl(Composite parent) {
		
		initializeDialogUnits(parent);
		
		control = new CodeUpdatePreviewOptionsGroup(parent, SWT.NONE);
		control.initialize(ToolsUiPlugin.getDefault().getPreferenceStore());
		
		setControl(control);
	}
	
	protected void saveContent() {
		control.save(ToolsUiPlugin.getDefault().getPreferenceStore());
	}
}
