/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TypeValidator.java,v 1.6 2008/02/28 17:04:30 jkubasta Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.java.junit;

import org.eclipse.hyades.test.tools.core.common.TestCommon;
import org.eclipse.hyades.ui.extension.ITypeValidator;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class TypeValidator implements ITypeValidator
{
	/**
	 * @see org.eclipse.hyades.ui.extension.ITypeValidator#isValidType(java.lang.String)
	 */
	public boolean isValidType(String type)
	{
		if(TestCommon.HTTP_JUNIT_TEST_SUITE_TYPE.equals(type))
			return true;

		if(TestCommon.HTTP_JUNIT_TEST_CASE_TYPE.equals(type))
			return true;

		if(TestCommon.JUNIT_TEST_SUITE_TYPE.equals(type))
			return true;

		if(TestCommon.JUNIT_TEST_CASE_TYPE.equals(type))
			return true;
			
		if (TestCommon.OTHER_JUNIT_TEST_SUITE_TYPE.equals(type))
			return true;
		
		if (TestCommon.OTHER_JUNIT_TEST_CASE_TYPE.equals(type))
			return true;
		
		return false;
	}
}
