/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AnalyzerExtensionSamplePlugin.java,v 1.2 2008/03/13 11:02:11 jkubasta Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.tptp.analyzer.extension.sample;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class AnalyzerExtensionSamplePlugin extends Plugin {
	public static final String PLUGIN_ID = "AnalyzerExtensionSample"; //$NON-NLS-1$
	private static AnalyzerExtensionSamplePlugin plugin;
	private ResourceBundle resourceBundle;
	
	/**
	 * The constructor.
	 */
	public AnalyzerExtensionSamplePlugin() {
		plugin = this;
		try {
			resourceBundle = getResourceBundle();
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * Returns the shared instance.
	 */
	public static AnalyzerExtensionSamplePlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = AnalyzerExtensionSamplePlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle.
	 */
	public ResourceBundle getResourceBundle() {
		if(resourceBundle == null) {
			try {
				resourceBundle = Platform.getResourceBundle(Platform.getBundle(PLUGIN_ID));
			} catch (Exception e) {
				resourceBundle = null;
			}
		}
		return resourceBundle;
	}
}
