/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenAnalyzerExtensionSampleViewAction.java,v 1.2 2008/03/13 11:02:09 jkubasta Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.tptp.analyzer.extension.sample.actions;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.actions.OpenAssociatedTraceViewAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.tptp.analyzer.extension.sample.views.AnalyzerExtensionSampleView;
import org.eclipse.ui.IWorkbenchPage;


public class OpenAnalyzerExtensionSampleViewAction extends OpenAssociatedTraceViewAction {
	private static final String VIEW_ID = "org.eclipse.tptp.analyzer.extension.sample.views.AnalyzerExtensionSampleView";

	public OpenAnalyzerExtensionSampleViewAction() {
		super("");
	}
	
	private void openView() {
		try {
			IWorkbenchPage persp = UIPlugin.getActivePage();
			AnalyzerExtensionSampleView view = (AnalyzerExtensionSampleView) persp.showView(VIEW_ID);
			view.refresh();
		} catch (Exception e) {
			
			e.printStackTrace();
		}		
	}
	public void run() {
		openView();
	}
	public void run(IAction action) {
		run();
	}

	public String getViewID() {
		return VIEW_ID;
	}
}
