/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AnalyzerExtensionSampleView.java,v 1.2 2008/03/13 11:02:12 jkubasta Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.tptp.analyzer.extension.sample.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.tptp.analyzer.extension.sample.AnalyzerExtensionSamplePlugin;
import org.eclipse.ui.part.ViewPart;


public class AnalyzerExtensionSampleView extends ViewPart {

	private Label desc;
	
	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
		desc = new Label(parent, SWT.WRAP);
		
		refresh();
	}

	public void refresh()
	{
		EObject eObj = HyadesUtil.getMofObject();
		
		String textToPrint = null;

		if (eObj != null)
		{
			if (eObj instanceof TRCMonitor)
				textToPrint = ((TRCMonitor)eObj).getName();
			else if (eObj instanceof TRCNode)
				textToPrint = ((TRCNode)eObj).getName();
			else if (eObj instanceof TRCProcessProxy)
				textToPrint = ((TRCProcessProxy)eObj).getName();
			else if (eObj instanceof TRCAgentProxy)
				textToPrint = ((TRCAgentProxy)eObj).getName();			
		}
		else
			textToPrint = AnalyzerExtensionSamplePlugin.getResourceString("ANALYZER_VIEW_TEXT_NO_NAME");
		

		desc.setText(AnalyzerExtensionSamplePlugin.getResourceString("ANALYZER_VIEW_TEXT")+ textToPrint);
		GridData data = new GridData();
		desc.setLayoutData(data);
	}
	
	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
	 */
	public void setFocus() {
	}
}
