/*******************************************************************************
 * Copyright (c) 2005,2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CLanguagePluginImages.java,v 1.1 2006/03/07 15:37:16 rlee Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.tptp.context.sample;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class CLanguagePluginImages
{
  private static URL fgIconBaseURL= null;

	static {
		try {
			fgIconBaseURL= new URL(ClanguagePlugin.getDefault().getBundle().getEntry("/"), "icons/full/"); //$NON-NLS-1$ //$NON-NLS-2$
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}
	}	
  	
	public static final String T_OBJ		= "obj16"; //$NON-NLS-1$
	
  public static Hashtable _images;  
	
  public static final String IMG_NAMESPACE = "namespace.gif"; //$NON-NLS-1$
  public static final String IMG_COMPUNIT = "compileunit.gif";//$NON-NLS-1$
  public static final String IMG_FUNCTION = "function.gif";//$NON-NLS-1$

  // there following String are all $NON-NLS-1$
  public static final Image DESC_IMG_NAMESPACE   = createManaged(T_OBJ,IMG_NAMESPACE);//$NON-NLS-1$
  public static final Image DESC_IMG_COMPUNIT   = createManaged(T_OBJ,IMG_COMPUNIT);//$NON-NLS-1$
  public static final Image DESC_IMG_FUNCTION  = createManaged(T_OBJ,IMG_FUNCTION);//$NON-NLS-1$

public static Image getImage(String name)
{
	return (Image) _images.get(name);
}

private static Image createManaged(String prefix, String name) {
	try {
		Image result = ImageDescriptor.createFromURL(makeIconFileURL(prefix, name)).createImage();
	
		if(_images == null)
		{
			_images = new Hashtable();		
		}
			
		_images.put(name, result);
		return result;
			
	} catch (MalformedURLException e) {
		return ImageDescriptor.getMissingImageDescriptor().createImage();
	}
}

private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
	if (fgIconBaseURL == null)
		throw new MalformedURLException();

	StringBuffer buffer;
    if (prefix!=null) 
    {
		buffer= new StringBuffer(prefix);
		buffer.append('/');
		buffer.append(name);
    }
    else 
    {
    	buffer= new StringBuffer(name);
    }
	return new URL(fgIconBaseURL, buffer.toString());
}
      
public static void shutdown()
{
	_images.clear();
	_images = null;	
}

}
