/*******************************************************************************
 * Copyright (c) 2005,2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CContextProvider.java,v 1.1 2006/03/07 15:37:14 rlee Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.tptp.context.sample.clanguage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.hyades.ui.provisional.context.IContextProvider;
import org.eclipse.tptp.context.sample.clanguage.Messages;

public class CContextProvider implements IContextProvider {

	private Map contextLabelFormatProviders;
	private List supportAttributes;

	
	public CContextProvider()
	{
		contextLabelFormatProviders = new HashMap();
		supportAttributes = new ArrayList();
		
		supportAttributes.add(IContextAttributes.PACKAGE_NAME);
		supportAttributes.add(IContextAttributes.CLASS_NAME);
		supportAttributes.add(IContextAttributes.METHOD_NAME);
		supportAttributes.add(IContextAttributes.SHOW_PACKAGE_LEVEL);
		supportAttributes.add(IContextAttributes.SHOW_CLASS_LEVEL);
		supportAttributes.add(IContextAttributes.SHOW_METHOD_LEVEL);
		supportAttributes.add(IContextAttributes.PACKAGE_BASE_TIME);
		supportAttributes.add(IContextAttributes.CLASS_BASE_TIME);
		supportAttributes.add(IContextAttributes.METHOD_BASE_TIME);
		supportAttributes.add(IContextAttributes.OBJECT_COLLECTED);
	}
	
	public String getName() {
		return Messages.getString("CContextProvider.1"); //$NON-NLS-1$
	}

	public String getDescription() {
		// TODO Auto-generated method stub
		return null;
	}

	public String[] getSupportAttributes() {
		String[] supportAttributesA = new String[supportAttributes.size()];
		supportAttributes.toArray(supportAttributesA);
		return supportAttributesA;		
	}

	public IContextLabelFormatProvider getContextLabelFormatProvider(String key) {
		Object result = contextLabelFormatProviders.get(key);	
		if (result != null) {
			return (IContextLabelFormatProvider)result;
		}
		else {
			if (supportAttributes.contains(key)) {
				if (key.equals(IContextAttributes.PACKAGE_NAME)) result = new NameSpaceFormatter();
				if (key.equals(IContextAttributes.CLASS_NAME)) result = new  CompileUnitFormatter();
				if (key.equals(IContextAttributes.METHOD_NAME)) result = new  MethodUnitFormatter();
				if (key.equals(IContextAttributes.SHOW_PACKAGE_LEVEL)) result = new  ShowNameSpaceFormatter();
				if (key.equals(IContextAttributes.SHOW_CLASS_LEVEL)) result = new  ShowCompileUnitFormatter();
				if (key.equals(IContextAttributes.SHOW_METHOD_LEVEL)) result = new  ShowFunctionFormatter();
				if (key.equals(IContextAttributes.PACKAGE_BASE_TIME)) result = new NameSpaceBaseTimeFormatter();
				if (key.equals(IContextAttributes.CLASS_BASE_TIME)) result = new CompileUnitBaseTimeFormatter();
				if (key.equals(IContextAttributes.METHOD_BASE_TIME)) result = new FunctionBaseTimeFormatter();
				if (key.equals(IContextAttributes.OBJECT_COLLECTED)) result = new ObjectCollectedFormatter();
			}
			if (result!=null) {
				contextLabelFormatProviders.put(key,result);
				return (IContextLabelFormatProvider)result;
			}
		}
		
		return null;
	}

	public String getBaseProvider() {
		return "Java"; //$NON-NLS-1$
	}
}
