/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ContextOpenSourceProviderSample.java,v 1.2 2008/05/29 20:44:59 ewchan Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.tptp.context.sample.clanguage;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.provisional.context.IContextOpenSourceProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.context.sample.clanguage.Messages;

public class ContextOpenSourceProviderSample implements
		IContextOpenSourceProvider {
	
	public boolean openSource(String context, EObject selection)
	{
		
		String message = Messages.getString("ContextOpenSourceProviderSample.0"); //$NON-NLS-1$
		message = message.replaceFirst("%1", context); //$NON-NLS-1$
		String name;
		if (selection instanceof TRCClass)
			name = ((TRCClass)selection).getName();
		else if (selection instanceof TRCMethod)
			name = ((TRCMethod)selection).getName();
		else
			name = ""; //$NON-NLS-1$
			
		message = message.replaceFirst("%2", name); //$NON-NLS-1$
		
		final String tmessage = message;
		
		Display.getDefault().syncExec(new Runnable() {
			public void run() {
					MessageDialog.openInformation(HyadesUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell(),
							Messages.getString("ContextOpenSourceProviderSample.4"), //$NON-NLS-1$
							tmessage);
				}
			});
		
		return true;
	}
	
	public String getName() {
		return Messages.getString("ContextOpenSourceProviderSample.5"); //$NON-NLS-1$
	}
}
