/*******************************************************************************
 * Copyright (c) 2005,2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ShowFunctionFormatter.java,v 1.1 2006/03/07 15:37:13 rlee Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.tptp.context.sample.clanguage;

import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.context.sample.CLanguagePluginImages;

public class ShowFunctionFormatter implements IContextLabelFormatProvider {

		public String getDisplayStringFromElement(Object value, Object element, int mode) {
			return Messages.getString("ShowFunctionFormatter.0"); //$NON-NLS-1$
		}

		public Image getDisplayImageByElement(Object value, Object element, int mode) {
			return CLanguagePluginImages.getImage(CLanguagePluginImages.IMG_FUNCTION);
		}
		
		public String getDisplayDescription() {
			return Messages.getString("ShowFunctionFormatter.1"); //$NON-NLS-1$
		}

		public String getDisplayToolTip() {
			return Messages.getString("ShowFunctionFormatter.1"); //$NON-NLS-1$
		}	

		public String convertModelValueToDisplayString(String text) {
			return text;
		}

		public String convertDisplayStringToModelValue(String text) {
			return text;
		}

		public Double comparableDoubleValue(Object element) {
			return null;
		}
		
		private int[] supportedModes = null;
		
		public int[] getSupportModes() {
			
			if (supportedModes == null)
			{
				supportedModes = new int[1];
				supportedModes[0] = IContextLabelFormatProvider.MODE_VIEW_ACTION;
			}
			
			return supportedModes;
		}
}
