/*******************************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HTMLContentProvider.java,v 1.2 2010/02/26 19:19:58 jcayne Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.tptp.content.provider.sample;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.provisional.extension.ICustomContentProvider;

public class HTMLContentProvider implements ICustomContentProvider {

	public HTMLContentProvider() {
	}

	public boolean isValidResource(IResource res) {
		if(res.getFileExtension().equals("html")) //$NON-NLS-1$
			return true;
		return false;
	}

	public INavigatorItem getContribution(IResource res) {
		return new HTMLNavItem(res);
	}

}
