/*******************************************************************************
 * Copyright (c) 2005,2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.tptp.filtertype.extension.sample.filter.definitions;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;

public class ExpressionUtil {

	/**
	 * This method creates a BinaryExpression for the given Binary expression attributes. 
	 * @param feature
	 * @param operator
	 * @param value
	 * @param caseInsensitive
	 * @return
	 */
	public static BinaryExpression createBinaryExpression(EStructuralFeature feature, RelationalOperators operator, String value, boolean caseInsensitive)
	{
		BinaryExpression binaryExpression = ExtensionsFactory.eINSTANCE.createBinaryExpression(); 
		
		SimpleOperand leftOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
		leftOperand.setFeature(feature);

		binaryExpression.setLeftOperand(leftOperand);
		
		binaryExpression.setOperator(operator);

		SimpleOperand rightOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
		if (feature instanceof EAttribute)
			rightOperand.setValueType(((EAttribute)feature).getEAttributeType());
		rightOperand.setValue(value);		
		binaryExpression.getRightOperands().add(rightOperand);

		binaryExpression.setCaseInsensitive(caseInsensitive);
		
		return binaryExpression;
	}
}
