/*******************************************************************************
 * Copyright (c) 2005,2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.tptp.filtertype.extension.sample.filter.definitions;

import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.ui.filters.IAdvancedTabAttributeSet;
import org.eclipse.hyades.ui.filters.IFilterAttribute;
import org.eclipse.hyades.ui.internal.filters.BasicFeatureFilterAttribute;
import org.eclipse.tptp.filtertype.extension.sample.FilterTypeSamplePlugin;

/**
 * This class implements IAdvancedTabAttributeSet, it contains the list of attributes
 * that will be displayed in the advanced tab.
 *
 */
public class SampleAdvancedTabAttributeSet implements IAdvancedTabAttributeSet{


	// creates an operator set
	private static RelationalOperators[] _operators = new RelationalOperators[]
	   {
			RelationalOperators.get(RelationalOperators.EQ),
			RelationalOperators.get(RelationalOperators.LIKE),
			RelationalOperators.get(RelationalOperators.NEQ),
			RelationalOperators.get(RelationalOperators.GT),
			RelationalOperators.get(RelationalOperators.LT),
			RelationalOperators.get(RelationalOperators.GE),
			RelationalOperators.get(RelationalOperators.LE)
	   };
	
	//Below we create the list of attributes to be displayed in the advanced tab for this filter type.
	//Notice the unique IDs {ftsample_ad1, ftsample_ad2, ftsample_ad3}, they must be unique to differentiate them.
	//BasicFeatureFilterAttribute is an internal class where we create simple attributes based on a feature, with
	//   the given operators and display string.  
	//SampleFilterAttribute is an attribute created for this sample
	private IFilterAttribute [] _attributes = new IFilterAttribute[]
		{
			new BasicFeatureFilterAttribute("ftsample_ad1", FilterTypeSamplePlugin.getResourceString("STR_FILTER_CLASS_NAME"), TracePackage.eINSTANCE.getTRCClass_Name(), _operators, true),
		    new BasicFeatureFilterAttribute("ftsample_ad2", FilterTypeSamplePlugin.getResourceString("STR_FILTER_METHOD_NAME"), TracePackage.eINSTANCE.getTRCMethod_Name(), _operators, true),
		    new SampleFilterAttribute("ftsample_ad3")
		};
	
	
	/**
	 * @see IAdvancedTabAttributeSet#getAttributes()
	 */
	public IFilterAttribute[] getAttributes() {
		return _attributes;
	}

}
