/*******************************************************************************
 * Copyright (c) 2005,2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.tptp.filtertype.extension.sample.filter.definitions;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.filtertype.extension.sample.FilterTypeSamplePlugin;

/**
 * Implements the standard tab UI for the sample filter type created in this sample.
 * It consists of a simple text box for the package name and a case sensitive
 * check box.
 *
 */

public class SampleFilterStandardTabUI extends FiltersStandardTabUI {
	
	private Text filterText;
	private Button caseControl;

	/**
	 * @see FiltersStandardTabUI#createControl(org.eclipse.swt.widgets.Composite)
	 */	
	public Control createControl(Composite parent) {
		Composite content = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		content.setLayout(layout);
		GridData data = GridUtil.createFill();
		data.minimumHeight = 400;
		data.minimumWidth = 400;		
		content.setLayoutData(data);

		Label filter = new Label(content, SWT.NULL);
		filter.setText(FilterTypeSamplePlugin.getResourceString("STR_PACKAGE_NAME"));		
		
		filterText = new Text(content, SWT.BORDER);
		filterText.setLayoutData(GridUtil.createHorizontalFill());

		caseControl = new Button(content, SWT.CHECK);
		caseControl.setLayoutData(new GridData());
		caseControl.setText(FilterTypeSamplePlugin.getResourceString("STR_CASE_SENSITIVE"));
		
		return content;
	}

	/**
	 * @see FiltersStandardTabUI#initializeFrom(org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery)
	 */	
	public void initializeFrom(SimpleSearchQuery filter) {
		filterText.setText("");
		caseControl.setSelection(true);
		
		if (filter.getWhereExpression() != null 
				&& (filter.getWhereExpression() instanceof LogicalExpression))
		{
			 LogicalExpression logicalExpression = (LogicalExpression)filter.getWhereExpression();
			 EList filterElements = logicalExpression.getArguments();

			 if (filterElements.size() > 0)
			 {
				BinaryExpression be = (BinaryExpression)filterElements.get(0);
				filterText.setText(String.valueOf(((SimpleOperand)be.getRightOperands().get(0)).getRawValue()));
				caseControl.setSelection(!be.isCaseInsensitive());
			}
		}
	}

	/**
	 * @see FiltersStandardTabUI#performApply()
	 */
	public SimpleSearchQuery performApply() {
		SimpleSearchQuery filter = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();		
		LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
		logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
		EList arguments = logicalExpression.getArguments();
		
		if (filterText.getText().trim().length() > 0)
		{
			arguments.add(ExpressionUtil.createBinaryExpression(TracePackage.eINSTANCE.getTRCPackage_Name(), RelationalOperators.get(RelationalOperators.LIKE), filterText.getText().trim(), !caseControl.getSelection()));
		}
		
		filter.setWhereExpression(logicalExpression);
		
		return filter;
	}
}
