/*******************************************************************************
 * Copyright (c) 2005,2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.tptp.filtertype.extension.sample.views;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.ui.filters.FilterActions;
import org.eclipse.hyades.ui.filters.IFilterQueryProvider;
import org.eclipse.hyades.ui.filters.IFilterViewer;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.tptp.filtertype.extension.sample.FilterTypeSamplePlugin;
import org.eclipse.ui.part.ViewPart;

/**
 * This sample view, simply shows the package listing for the selected
 * object.
 *
 */
public class FilterTypeSampleView extends ViewPart implements IFilterViewer {

	private static final String[] FILTER_TYPE_SAMPLE_SCOPE = {"FilterTypeSampleScope"};
	
	private IFilterQueryProvider _fqp;
	
	private org.eclipse.swt.widgets.List packagesList;
	
	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
		
		Composite content = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		content.setLayout(layout);
		GridData data = GridUtil.createFill();
		content.setData(data);
		
		Label heading = new Label(content, SWT.SHADOW_OUT);
		heading.setText(FilterTypeSamplePlugin.getResourceString("FILTER_VIEW_TEXT"));

		
		packagesList = new org.eclipse.swt.widgets.List(content, SWT.SINGLE);
		data = GridUtil.createFill();
		packagesList.setLayoutData(data);		
		
		
		makeActions();
	}

	/**
	 * Refreshes the package listing in the view.
	 */
	public void refresh()
	{
		// return the selected EObject
		EObject eObj = HyadesUtil.getMofObject();
		
		packagesList.removeAll();

		if (eObj != null)
		{
			// Here we get the process list that is selected, we will send this as a source to the filtering engine
			List source = FilterTypeSampleFilteringUtil.getProcessList(eObj); 
			EObject[] sourceEObjects = new EObject[source.size()];
			source.toArray(sourceEObjects);
			
			// Here we get the filtered packages with the currently selected filter and source objects,
			//   this call, eventuall delegates to the filtering engine
			List packages = FilterTypeSampleFilteringUtil.getFilteredPackages(_fqp.getCurrentFilter(), sourceEObjects);
			
			for (int i = 0; i < packages.size(); i++)
			{
				String name = ((TRCPackage)packages.get(i)).getName();
				
				if ("".equals(name))
					name = FilterTypeSamplePlugin.getResourceString("FILTER_VIEW_DEFAULT_PACKAGE");

				packagesList.add(name);
			}
		}
		else
			packagesList.add(FilterTypeSamplePlugin.getResourceString("FILTER_VIEW_TEXT_NO_OBJECT"));
		
		
		packagesList.redraw();
	}
	
	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
	 */
	public void setFocus() {
	}

	/**
	 * Creates the actions visible.  This creates the filter selection action.
	 * This for the filters, is a drop down action and editing action.
	 */
	public void makeActions()
	{
		IToolBarManager tbm = getViewSite().getActionBars().getToolBarManager();
		tbm.removeAll();
		
		//Creates the filter action combo box visible in the view for
		//  selecting and creating filters.
		tbm.add(FilterActions.getFiltersSelectionAction(this));
		
		getViewSite().getActionBars().updateActionBars();		
	}	

	/**
	 * @see IFilterViewer#filterUpdated()
	 */
	public void filterUpdated() {
		refresh();
	}

	/**
	 * @see IFilterViewer#setFilterQueryProvider(org.eclipse.hyades.ui.filters.IFilterQueryProvider)
	 */	
	public void setFilterQueryProvider(IFilterQueryProvider fqp) {
		_fqp = fqp;
	}

	/**
	 * @see IFilterViewer#getFilterScope()
	 */	
	public String[] getFilterScope() {
		return FILTER_TYPE_SAMPLE_SCOPE;
	}
	
	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#dispose()
	 */
    public void dispose() {
    	super.dispose();
    	
    	// This method must be called when the viewer is disposed
    	_fqp.viewerDisposed();
    }
}
