/*******************************************************************************
 * Copyright (c) 2005,2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SampleNavigatorExtension.java,v 1.2 2006/05/11 18:17:29 dnsmith Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * Extends the Profiling Monitor, providing sample items under
 * every EMF object. A sample action is also provided in the
 * context menu. You can also add actions to the built-in types
 * in the same way.
 */
public class SampleNavigatorExtension implements INavigatorContribution {

	public boolean hasChildren(Object item) {
		if (item instanceof INavigatorItem)
			return ((INavigatorItem)item).hasChildren();
		return SampleItemRegistry.hasChildren(item);
	}
	
	public List getChildren(Object item) {
		if (item instanceof SampleItem)
			return ((INavigatorItem)item).getChildren();
		return SampleItemRegistry.getChildren(item);
	}
	
	// non-persistent items
	public Collection getModifiedItems() {
		return new ArrayList(0);
	}

	public void fillContextMenu(IMenuManager menu, IStructuredSelection selection) {
		final Object[] items = selection.toArray();
		if (items.length == 1 && items[0] instanceof EObject) {
			menu.appendToGroup(GROUP_ADDITIONS, new Action() {
				public String getText() {
					return SamplePlugin.getResourceString("NAVIGATOR_EXTENSION_ACTION_LABEL");
				}
				
				public ImageDescriptor getImageDescriptor() {
					try {
						URL url = SamplePlugin.getDefault().find(new Path("icons/full/obj16/sample.gif"));
						return ImageDescriptor.createFromURL(url);
					}
					catch (Exception e) {
						e.printStackTrace();
						return null;
					}
				}
				
				public void run() {
					SampleItem item = new SampleItem(items[0]);
					SampleItemRegistry.addChild(items[0], item);
					PDProjectExplorer.getFromActivePerspective().refreshView(item.getParent());
				}
			});
		}
	}

	public void dispose() {
	}
}
